package net.devtech.arrp.json.iteminfo.tint;

import com.google.gson.JsonObject;

/**
 * Abstract base class for tint sources.
 */
public abstract class JTint implements Cloneable {
    private final String type;

    protected JTint(String type) {
        this.type = type;
    }

    // Static factory methods for different tint types
    public static JTintConstant constant(Object value) {
        return new JTintConstant(value);
    }

    public static JTintTeam team(Object value) {
        return JTintTeam.of(value);
    }

    // Getter
    public String getType() {
        return type;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        return json;
    }

    // Clone method to be implemented by subclasses
    @Override
    public abstract JTint clone();
}
