package net.devtech.arrp.json.iteminfo.tint;

import com.google.gson.JsonObject;

import java.util.List;

/**
 * Represents a dye tint source.
 */
public class JTintDye extends JTint {
    private int defaultColor;

    public JTintDye() {
        super("dye");
    }

    public JTintDye(Object defaultColor) {
        this();
        setDefaultColor(defaultColor);
    }

    // Getter and Setter
    public Object getDefaultColor() {
        return defaultColor;
    }

    public void setDefaultColor(Object defaultColor) {
        if (defaultColor instanceof Number) {
            this.defaultColor = ((Number) defaultColor).intValue();
        } else if (defaultColor instanceof List<?> colorList) {
			// Example parse: assume [r, g, b]
            if (colorList.size() == 3
                    && colorList.get(0) instanceof Number
                    && colorList.get(1) instanceof Number
                    && colorList.get(2) instanceof Number) {
                int r = ((Number) colorList.get(0)).intValue();
                int g = ((Number) colorList.get(1)).intValue();
                int b = ((Number) colorList.get(2)).intValue();
                this.defaultColor = (r << 16) | (g << 8) | b;
            } else {
                throw new IllegalArgumentException("Expected a list of three numeric values (RGB).");
            }
        } else {
            throw new IllegalArgumentException("Unsupported color format.");
        }
    }

    public void defaultColor(Object defaultColor) {
        setDefaultColor(defaultColor);
    }

    @Override
    public JsonObject toJson() {
        JsonObject parent = super.toJson();
        parent.addProperty("default", defaultColor);
        return parent;
    }

    @Override
    public JTintDye clone() {
        return new JTintDye(this.defaultColor);
    }
}
