package net.devtech.arrp.json.iteminfo.tint;

/**
 * Represents the "minecraft:foliage" tint source.
 */
public class JTintFoliage extends JTint {
    private float temperature;
    private float downfall;

    protected JTintFoliage() {
        super("foliage");
    }

    // Static factory method
    public static JTintFoliage foliage() {
        return new JTintFoliage();
    }

    // Fluent methods
    public JTintFoliage temperature(float temperature) {
        this.temperature = temperature;
        return this;
    }

    public JTintFoliage downfall(float downfall) {
        this.downfall = downfall;
        return this;
    }

    // Getters
    public float getTemperature() {
        return temperature;
    }

    public float getDownfall() {
        return downfall;
    }

    @Override
    public JTintFoliage clone() {
        JTintFoliage cloned = new JTintFoliage();
        cloned.temperature = this.temperature;
        cloned.downfall = this.downfall;
        return cloned;
    }
}
