package net.devtech.arrp.json.iteminfo.tint;

/**
 * Represents the "minecraft:team" tint source type.
 */
public class JTintTeam extends JTint {
    private Object defaultColor; // RGB value (Integer or List<Integer>)

    public JTintTeam() {
        super("team");
    }

    public static JTintTeam of(Object defaultColor) {
        return new JTintTeam().defaultColor(defaultColor);
    }

    // Getter and Setter
    public Object getDefaultColor() {
        return defaultColor;
    }

    public JTintTeam defaultColor(Object defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    @Override
    public JTintTeam clone() {
        JTintTeam cloned = new JTintTeam();
        cloned.defaultColor(this.defaultColor);
        return cloned;
    }
}
