package net.devtech.arrp.json.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class JLang implements Cloneable {
    private final Map<String, String> lang = new HashMap<>();

    /**
     * @see #lang()
     */
    public JLang() {
    }

    public static JLang lang() {
        return new JLang();
    }

    /**
     * Adds a custom entry to the lang file. (deprecated: renamed to a more intuitive name)
     *
     * @param in  the translation string
     * @param out the in-game name of the object
     * @return the file with the new entry.
     * @deprecated use {@link #entry(String, String)} instead.
     */
    @Deprecated
    public JLang translate(String in, String out) {
        this.lang.put(in, out);
        return this;
    }

    private <T> JLang object(class_2378<T> registry, String str, T t, String name) {
        return this.object(str,
                Objects.requireNonNull(registry.method_10221(t), "register your item before calling this"),
                name);
    }

    private JLang object(String type, class_2960 identifier, String translation) {
        this.lang.put(type + '.' + identifier.method_12836() + '.' + identifier.method_12832(), translation);
        return this;
    }

    public JLang entry(String entry, String name) {
        this.lang.put(entry, name);
        return this;
    }


    /**
     * adds a translation key for an item, respects {@link class_1792#method_7876()}
     */
    public JLang itemRespect(class_1792 item, String name) {
        this.lang.put(item.method_7876(), name);
        return this;
    }

    public JLang item(class_1799 stack, String name) {
        this.lang.put(stack.method_7909().method_7876(), name);
        return this;
    }

    /**
     * @see JLang#itemRespect(class_1792, String) uses the {@link class_1792#method_7876()}}
     */
    @Deprecated
    public JLang item(class_1792 item, String name) {
        return this.object(class_7923.field_41178, "item", item, name);
    }

    /**
     * adds a translation key for an block, respects {@link class_2248#method_63499()}
     */
    public JLang blockRespect(class_2248 block, String name) {
        this.lang.put(block.method_63499(), name);
        return this;
    }

    /**
     * @see JLang#blockRespect(class_2248, String) uses the {@link class_2248#method_63499()}}
     */
    @Deprecated
    public JLang block(class_2248 block, String name) {
        return this.object(class_7923.field_41175, "block", block, name);
    }

    public JLang fluid(class_3611 fluid, String name) {
        return this.object(class_7923.field_41173, "fluid", fluid, name);
    }

    /**
     * adds a translation key for an entity, respects {@link class_1299#method_5882()}
     */
    public JLang entityRespect(class_1299<?> type, String name) {
        this.lang.put(type.method_5882(), name);
        return this;
    }

    /**
     * @see JLang#entityRespect(class_1299, String) uses the {@link class_1299#method_5882()}}
     */
    @Deprecated
    public JLang entity(class_1299<?> type, String name) {
        return this.object(class_7923.field_41177, "entity_type", type, name);
    }

    public JLang item(class_2960 item, String name) {
        return this.object("item", item, name);
    }

    public JLang block(class_2960 block, String name) {
        return this.object("block", block, name);
    }

    public JLang fluid(class_2960 id, String name) {
        return this.object("fluid", id, name);
    }

    public JLang entity(class_2960 id, String name) {
        return this.object("entity_type", id, name);
    }

    public JLang enchantment(class_2960 id, String name) {
        return this.object("enchantment", id, name);
    }

    public JLang itemGroup(class_2960 id, String name) {
        return this.object("itemGroup", id, name);
    }

    public JLang sound(class_2960 id, String name) {
        return this.object("sound_event", id, name);
    }

    public JLang status(class_2960 id, String name) {
        return this.object("mob_effect", id, name);
    }

    /**
     * Like {@link JLang#allPotion}, but it adds in the prefixes automatically.
     */
    public JLang allPotionOf(class_2960 id, String effectName) {
        this.allPotion(id,
                "Potion of " + effectName,
                "Splash Potion of " + effectName,
                "Lingering Potion of " + effectName,
                "Tipped Arrow of " + effectName);
        return this;
    }

    public JLang allPotion(class_2960 id,
                           String drinkablePotionName,
                           String splashPotionName,
                           String lingeringPotionName,
                           String tippedArrowName) {
        return this.drinkablePotion(id, drinkablePotionName).splashPotion(id, splashPotionName)
                .lingeringPotion(id, lingeringPotionName).tippedArrow(id, tippedArrowName);
    }

    public JLang tippedArrow(class_2960 id, String name) {
        this.lang.put("item.minecraft.tipped_arrow.effect." + id.method_12832(), name);
        return this;
    }

    public JLang lingeringPotion(class_2960 id, String name) {
        this.lang.put("item.minecraft.lingering_potion.effect." + id.method_12832(), name);
        return this;
    }

    public JLang splashPotion(class_2960 id, String name) {
        this.lang.put("item.minecraft.splash_potion.effect." + id.method_12832(), name);
        return this;
    }

    public JLang drinkablePotion(class_2960 id, String name) {
        this.lang.put("item.minecraft.potion.effect." + id.method_12832(), "Potion of " + name);
        return this;
    }

    /**
     * Like {@link JLang#drinkablePotion}, but it adds in the "Potion of" automatically.
     */
    public JLang drinkablePotionOf(class_2960 id, String effectName) {
        this.lang.put("item.minecraft.potion.effect." + id.method_12832(), "Potion of " + effectName);
        return this;
    }

    /**
     * Like {@link JLang#splashPotion}, but it adds in the "Splash Potion of" automatically.
     */
    public JLang splashPotionOf(class_2960 id, String effectName) {
        this.lang.put("item.minecraft.splash_potion.effect." + id.method_12832(), "Splash Potion of " + effectName);
        return this;
    }

    /**
     * Like {@link JLang#lingeringPotion}, but it adds in the "Lingering Potion of" automatically.
     */
    public JLang lingeringPotionOf(class_2960 id, String effectName) {
        this.lang.put("item.minecraft.lingering_potion.effect." + id.method_12832(), "Lingering Potion of " + effectName);
        return this;
    }

    /**
     * Like {@link JLang#tippedArrow}, but it adds in the "Tipped Arrow of" automatically.
     */
    public JLang tippedArrowOf(class_2960 id, String effectName) {
        this.lang.put("item.minecraft.tipped_arrow.effect." + id.method_12832(), "Tipped Arrow of " + effectName);
        return this;
    }

    public JLang biome(class_2960 id, String name) {
        return this.object("biome", id, name);
    }

    public Map<String, String> getLang() {
        return this.lang;
    }

    @Override
    public JLang clone() {
        try {
            return (JLang) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}
