package net.devtech.arrp;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.joml.Vector3f;

public final class JsonSerializers {
	public static final JsonSerializer<Either<?, ?>> EITHER = (src, type, context) -> src.map(context::serialize, context::serialize);
	public static final JsonSerializer<Vector3f> VECTOR_3F = (src, type, context) -> {
		final JsonArray array = new JsonArray();
		array.add(src.x);
		array.add(src.y);
		array.add(src.z);
		return array;
	};
	public static final JsonSerializer<class_3542> STRING_IDENTIFIABLE = (src, type, context) -> new JsonPrimitive(src.method_15434());
	public static final JsonSerializer<class_2960> IDENTIFIER = (src, type, context) -> new JsonPrimitive(src.toString());

	private JsonSerializers() {
	}

	public static <T> JsonSerializer<T> forCodec(Codec<T> codec) {
		return (src, typeOfSrc, context) -> codec.encodeStart(JsonOps.INSTANCE, src).getOrThrow();
	}

	public static <T> JsonSerializer<T> forCodec(Codec<T> codec, class_7225.class_7874 registryLookup) {
		final class_6903<JsonElement> ops = registryLookup.method_57093(JsonOps.INSTANCE);
		return (src, typeOfSrc, context) -> codec.encodeStart(ops, src).getOrThrow();
	}
}