package net.devtech.arrp.json.iteminfo.model.special;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.minecraft.class_2484;
import net.minecraft.class_2960;
import java.util.Locale;
import java.util.Optional;

/**
 * Represents the "minecraft:head" special model type.
 */
public class JModelHead extends JModelSpecial {
	public static final String TYPE = "minecraft:head";

	public static final Codec<JModelHead> CODEC = RecordCodecBuilder.create(i -> i.group(
			class_2484.class_2486.field_46443.fieldOf("kind").forGetter(m -> m.kind),
			Codec.FLOAT.optionalFieldOf("animation", 0.0F).forGetter(m -> m.animation),
			class_2960.field_25139.optionalFieldOf("texture").forGetter(m -> m.texture)
	).apply(i, JModelHead::new));

	static {
		JItemModel.register(TYPE, CODEC.xmap(m -> {
			m.type = TYPE;
			return m;
		}, m -> m));
	}

	private class_2484.class_2485 kind = class_2484.class_2486.field_11510; // safe default
	private float animation = 0.0F;
	private Optional<class_2960> texture = Optional.empty();

	public JModelHead() {
		super(TYPE);
	}

	public JModelHead(class_2484.class_2485 kind, float animation, Optional<class_2960> texture) {
		super(TYPE);
		this.kind = kind;
		this.animation = animation;
		this.texture = texture != null ? texture : Optional.empty();
	}

	private static class_2484.class_2485 parseKind(String s) {
		String n = s.toLowerCase(Locale.ROOT);
		for (var t : class_2484.class_2486.values()) if (t.method_15434().equals(n)) return t;
		throw new IllegalArgumentException("Unknown head kind: " + s);
	}

	// ---- API ----
	public class_2484.class_2485 getKind() {
		return kind;
	}

	public JModelHead kind(class_2484.class_2485 kind) {
		this.kind = kind;
		return this;
	}

	public JModelHead kind(String kind) {
		this.kind = parseKind(kind);
		return this;
	}

	public float getAnimation() {
		return animation;
	}

	public JModelHead animation(float animation) {
		this.animation = animation;
		return this;
	}

	public Optional<class_2960> getTexture() {
		return texture;
	}

	public JModelHead texture(Optional<class_2960> texture) {
		this.texture = texture;
		return this;
	}

	public JModelHead texture(class_2960 texture) {
		this.texture = Optional.ofNullable(texture);
		return this;
	}

	@Override
	public JModelHead clone() {
		JModelHead cloned = new JModelHead(this.kind, this.animation, this.texture);
		cloned.base(this.getBase());
		return cloned;
	}
}
