/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JPool;
import net.devtech.arrp.json.loot.JRoll;
import net.minecraft.class_2960;

public class JLootTable
implements Cloneable {
    public static final Codec<JLootTable> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("type").forGetter(JLootTable::getType), (App)JPool.CODEC.listOf().fieldOf("pools").forGetter(JLootTable::getPools), (App)class_2960.field_25139.optionalFieldOf("random_sequence").forGetter(t -> Optional.ofNullable(t.randomSequence))).apply((Applicative)i, (type, pools, rnd) -> {
        JLootTable t = new JLootTable((String)type, (List<JPool>)pools);
        rnd.ifPresent(t::randomSequence);
        return t;
    }));
    private final String type;
    private List<JPool> pools;
    private class_2960 randomSequence;

    public JLootTable(String type) {
        this.type = type;
    }

    public JLootTable(String type, List<JPool> pools) {
        this.type = type;
        this.pools = pools;
    }

    public static JLootTable loot(String type) {
        return new JLootTable(type);
    }

    public static JEntry entry() {
        return new JEntry();
    }

    public static JCondition predicate(String condition) {
        return new JCondition(condition);
    }

    public static JFunction function(String function) {
        return new JFunction(function);
    }

    public static JPool pool() {
        return new JPool();
    }

    public static JRoll roll(int min, int max) {
        return new JRoll(min, max);
    }

    public JLootTable randomSequence(class_2960 id) {
        this.randomSequence = id;
        return this;
    }

    public JLootTable randomSequence(String id) {
        return this.randomSequence(class_2960.method_12829((String)id));
    }

    public class_2960 getRandomSequence() {
        return this.randomSequence;
    }

    public JLootTable pool(JPool pool) {
        if (this.pools == null) {
            this.pools = new ArrayList<JPool>(1);
        }
        this.pools.add(pool);
        return this;
    }

    public JLootTable clone() {
        try {
            return (JLootTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public String getType() {
        return this.type;
    }

    public List<JPool> getPools() {
        return this.pools;
    }
}

