/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.devtech.arrp.json.worldgen.JAttributeValue;
import net.minecraft.class_2248;
import net.minecraft.class_3542;
import net.minecraft.class_6862;

public class JDimensionType {
    public static final Codec<JDimensionType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("has_skylight").orElse((Object)true).forGetter(dt -> dt.hasSkylight), (App)Codec.BOOL.fieldOf("has_ceiling").orElse((Object)false).forGetter(dt -> dt.hasCeiling), (App)Codec.DOUBLE.fieldOf("coordinate_scale").orElse((Object)1.0).forGetter(dt -> dt.coordinateScale), (App)IntProviderLike.CODEC.optionalFieldOf("monster_spawn_light_level").forGetter(dt -> Optional.ofNullable(dt.monsterSpawnLightLevel)), (App)Codec.INT.optionalFieldOf("monster_spawn_block_light_limit").forGetter(dt -> Optional.ofNullable(dt.monsterSpawnBlockLightLimit)), (App)Codec.INT.fieldOf("min_y").orElse((Object)-64).forGetter(dt -> dt.minY), (App)Codec.INT.fieldOf("height").orElse((Object)384).forGetter(dt -> dt.height), (App)Codec.INT.fieldOf("logical_height").orElse((Object)384).forGetter(dt -> dt.logicalHeight), (App)Codec.STRING.fieldOf("infiniburn").orElse((Object)"#minecraft:infiniburn_overworld").forGetter(dt -> dt.infiniburn), (App)Codec.FLOAT.fieldOf("ambient_light").orElse((Object)Float.valueOf(0.0f)).forGetter(dt -> Float.valueOf(dt.ambientLight)), (App)Codec.unboundedMap((Codec)Codec.STRING, JAttributeValue.CODEC).optionalFieldOf("attributes", Collections.emptyMap()).forGetter(dt -> dt.attributes == null ? Collections.emptyMap() : dt.attributes), (App)TimelinesRef.CODEC.optionalFieldOf("timelines").forGetter(dt -> Optional.ofNullable(dt.timelines)), (App)Skybox.CODEC.optionalFieldOf("skybox").forGetter(dt -> Optional.ofNullable(dt.skybox)), (App)CardinalLightType.CODEC.optionalFieldOf("cardinal_light").forGetter(dt -> Optional.ofNullable(dt.cardinalLight)), (App)Codec.BOOL.optionalFieldOf("has_fixed_time").forGetter(dt -> Optional.ofNullable(dt.hasFixedTime))).apply((Applicative)instance, (hasSkylight, hasCeiling, coordinateScale, monsterLightOpt, blockLimitOpt, minY, height, logicalHeight, infiniburn, ambientLight, attributesMap, timelinesOpt, skyboxOpt, cardinalOpt, hasFixedTimeOpt) -> {
        JDimensionType t = new JDimensionType();
        t.hasSkylight = hasSkylight;
        t.hasCeiling = hasCeiling;
        t.coordinateScale = coordinateScale;
        t.monsterSpawnLightLevel = monsterLightOpt.orElse(null);
        t.monsterSpawnBlockLightLimit = blockLimitOpt.orElse(null);
        t.minY = minY;
        t.height = height;
        t.logicalHeight = logicalHeight;
        t.infiniburn = infiniburn;
        t.ambientLight = ambientLight.floatValue();
        t.attributes = new LinkedHashMap<String, JAttributeValue>((Map<String, JAttributeValue>)attributesMap);
        t.timelines = timelinesOpt.orElse(null);
        t.skybox = skyboxOpt.orElse(null);
        t.cardinalLight = cardinalOpt.orElse(null);
        t.hasFixedTime = hasFixedTimeOpt.orElse(null);
        return t;
    }));
    private boolean hasSkylight = true;
    private boolean hasCeiling = false;
    private double coordinateScale = 1.0;
    private IntProviderLike monsterSpawnLightLevel;
    private Integer monsterSpawnBlockLightLimit;
    private int minY = -64;
    private int height = 384;
    private int logicalHeight = 384;
    private String infiniburn = "#minecraft:infiniburn_overworld";
    private float ambientLight = 0.0f;
    private Map<String, JAttributeValue> attributes = new LinkedHashMap<String, JAttributeValue>();
    private TimelinesRef timelines;
    private Skybox skybox;
    private CardinalLightType cardinalLight;
    private Boolean hasFixedTime;

    public static JDimensionType dimensionType() {
        return new JDimensionType();
    }

    public JDimensionType hasSkylight(boolean value) {
        this.hasSkylight = value;
        return this;
    }

    public JDimensionType hasCeiling(boolean value) {
        this.hasCeiling = value;
        return this;
    }

    public JDimensionType coordinateScale(double scale) {
        this.coordinateScale = scale;
        return this;
    }

    public JDimensionType monsterSpawnLightConstant(int value) {
        this.monsterSpawnLightLevel = IntProviderLike.constant(value);
        return this;
    }

    public JDimensionType monsterSpawnLightUniform(int minInclusive, int maxInclusive) {
        this.monsterSpawnLightLevel = IntProviderLike.uniform(minInclusive, maxInclusive);
        return this;
    }

    public JDimensionType monsterSpawnBlockLightLimit(int limit) {
        this.monsterSpawnBlockLightLimit = limit;
        return this;
    }

    public JDimensionType minY(int minY) {
        this.minY = minY;
        return this;
    }

    public JDimensionType height(int height) {
        this.height = height;
        return this;
    }

    public JDimensionType logicalHeight(int logicalHeight) {
        this.logicalHeight = logicalHeight;
        return this;
    }

    public JDimensionType infiniburn(class_6862<class_2248> infiniburnTagOrBlock) {
        this.infiniburn = infiniburnTagOrBlock.comp_327().toString();
        return this;
    }

    public JDimensionType ambientLight(float value) {
        this.ambientLight = value;
        return this;
    }

    public JDimensionType attribute(String key, boolean value) {
        if (key != null) {
            this.attributes.put(key, JAttributeValue.ofBoolean(value));
        }
        return this;
    }

    public JDimensionType attribute(String key, double value) {
        if (key != null) {
            this.attributes.put(key, JAttributeValue.ofDouble(value));
        }
        return this;
    }

    public JDimensionType attribute(String key, String value) {
        if (key != null && value != null) {
            this.attributes.put(key, JAttributeValue.ofString(value));
        }
        return this;
    }

    public <T> JDimensionType attribute(String key, Codec<T> codec, T value) {
        if (key != null && value != null) {
            this.attributes.put(key, JAttributeValue.ofEncoded(codec, value));
        }
        return this;
    }

    public Map<String, JAttributeValue> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public JDimensionType timeline(String id) {
        this.timelines = TimelinesRef.single(id);
        return this;
    }

    public JDimensionType timelines(List<String> ids) {
        this.timelines = TimelinesRef.list(ids);
        return this;
    }

    public JDimensionType timelinesTag(String tag) {
        this.timelines = TimelinesRef.tag(tag);
        return this;
    }

    public JDimensionType skybox(Skybox skybox) {
        this.skybox = skybox;
        return this;
    }

    public JDimensionType cardinalLight(CardinalLightType cardinalLightType) {
        this.cardinalLight = cardinalLightType;
        return this;
    }

    public JDimensionType hasFixedTime(boolean value) {
        this.hasFixedTime = value;
        return this;
    }

    public record IntProviderLike(Kind kind, int value, int minInclusive, int maxInclusive) {
        private final int minInclusive;
        private final int maxInclusive;
        private static final Codec<IntProviderLike> UNIFORM_WRAPPED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(p -> "minecraft:uniform"), (App)Codec.INT.fieldOf("min_inclusive").forGetter(IntProviderLike::minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(IntProviderLike::maxInclusive)).apply((Applicative)instance, (type, minInclusive, maxInclusive) -> IntProviderLike.uniform(minInclusive, maxInclusive)));
        public static final Codec<IntProviderLike> CODEC = Codec.either((Codec)Codec.INT, UNIFORM_WRAPPED_CODEC).xmap(either -> {
            if (either.left().isPresent()) {
                return IntProviderLike.constant((Integer)either.left().get());
            }
            return (IntProviderLike)either.right().get();
        }, provider -> {
            if (provider.kind == Kind.CONSTANT) {
                return Either.left((Object)provider.value);
            }
            return Either.right((Object)provider);
        });

        public static IntProviderLike constant(int value) {
            return new IntProviderLike(Kind.CONSTANT, value, 0, 0);
        }

        public static IntProviderLike uniform(int minInclusive, int maxInclusive) {
            return new IntProviderLike(Kind.UNIFORM, 0, minInclusive, maxInclusive);
        }

        public int constantValue() {
            if (this.kind != Kind.CONSTANT) {
                throw new IllegalStateException("Not a constant IntProvider");
            }
            return this.value;
        }

        public int minInclusive() {
            if (this.kind != Kind.UNIFORM) {
                throw new IllegalStateException("Not a uniform IntProvider");
            }
            return this.minInclusive;
        }

        public int maxInclusive() {
            if (this.kind != Kind.UNIFORM) {
                throw new IllegalStateException("Not a uniform IntProvider");
            }
            return this.maxInclusive;
        }

        public static enum Kind {
            CONSTANT,
            UNIFORM;

        }
    }

    public record TimelinesRef(String tag, List<String> timelineIds) {
        private final List<String> timelineIds;
        public static final Codec<TimelinesRef> CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.STRING)).xmap(either -> {
            if (either.left().isPresent()) {
                String value = (String)either.left().get();
                if (value.startsWith("#")) {
                    return TimelinesRef.tag(value);
                }
                return TimelinesRef.single(value);
            }
            return TimelinesRef.list((List)either.right().get());
        }, ref -> {
            if (ref.tag != null) {
                return Either.left((Object)ref.tag);
            }
            if (ref.timelineIds.size() == 1) {
                return Either.left((Object)ref.timelineIds.getFirst());
            }
            return Either.right(ref.timelineIds);
        });

        public static TimelinesRef single(String id) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(id);
            return new TimelinesRef(null, list);
        }

        public static TimelinesRef list(List<String> ids) {
            return new TimelinesRef(null, new ArrayList<String>(ids));
        }

        public static TimelinesRef tag(String tag) {
            return new TimelinesRef(tag, Collections.emptyList());
        }

        public List<String> timelineIds() {
            return Collections.unmodifiableList(this.timelineIds);
        }
    }

    public static enum Skybox implements class_3542
    {
        NONE("none"),
        OVERWORLD("overworld"),
        END("end");

        public static final Codec<Skybox> CODEC;
        private final String name;

        private Skybox(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Skybox::values);
        }
    }

    public static enum CardinalLightType implements class_3542
    {
        DEFAULT("default"),
        NETHER("nether");

        public static final Codec<CardinalLightType> CODEC;
        private final String name;

        private CardinalLightType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(CardinalLightType::values);
        }
    }

    public record IdWrapper(String id) {
        public static final Codec<IdWrapper> CODEC = Codec.STRING.xmap(IdWrapper::new, IdWrapper::id);
    }

    public record AttributeValue(Kind kind, boolean boolValue, double numberValue, String stringValue) {
        public static final Codec<AttributeValue> CODEC = Codec.either((Codec)Codec.BOOL, (Codec)Codec.either((Codec)Codec.DOUBLE, (Codec)Codec.STRING)).xmap(either -> {
            if (either.left().isPresent()) {
                return AttributeValue.of((Boolean)either.left().get());
            }
            Either right = (Either)either.right().get();
            if (right.left().isPresent()) {
                return AttributeValue.of((Double)right.left().get());
            }
            return AttributeValue.of((String)right.right().get());
        }, value -> switch (value.kind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Either.left((Object)value.boolValue);
            case 1 -> Either.right((Object)Either.left((Object)value.numberValue));
            case 2 -> Either.right((Object)Either.right((Object)value.stringValue));
        });

        public static AttributeValue of(boolean value) {
            return new AttributeValue(Kind.BOOLEAN, value, 0.0, null);
        }

        public static AttributeValue of(double value) {
            return new AttributeValue(Kind.NUMBER, false, value, null);
        }

        public static AttributeValue of(String value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            return new AttributeValue(Kind.STRING, false, 0.0, value);
        }

        public boolean asBoolean() {
            if (this.kind != Kind.BOOLEAN) {
                throw new IllegalStateException("Not a boolean");
            }
            return this.boolValue;
        }

        public double asNumber() {
            if (this.kind != Kind.NUMBER) {
                throw new IllegalStateException("Not a number");
            }
            return this.numberValue;
        }

        public String asString() {
            if (this.kind != Kind.STRING) {
                throw new IllegalStateException("Not a string");
            }
            return this.stringValue;
        }

        public static enum Kind {
            BOOLEAN,
            NUMBER,
            STRING;

        }
    }
}

