package net.devtech.arrp.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.JsonBytes;
import net.devtech.arrp.json.advancement.JAdvancement;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.equipmentinfo.JEquipmentModel;
import net.devtech.arrp.json.iteminfo.JItemInfo;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.json.timeline.JTimeline;
import net.devtech.arrp.json.worldgen.biome.JBiome;
import net.devtech.arrp.json.worldgen.dimension.JDimension;
import net.devtech.arrp.json.worldgen.dimension.JDimensionType;
import net.devtech.arrp.json.worldgen.feature.JConfiguredFeature;
import net.devtech.arrp.json.worldgen.feature.JPlacedFeature;
import net.devtech.arrp.json.worldgen.noise.JNoiseSettings;
import net.devtech.arrp.json.worldgen.structure.JStructure;
import net.devtech.arrp.json.worldgen.structure.JStructureSet;
import net.devtech.arrp.util.CallableFunction;
import net.devtech.arrp.util.CountingInputStream;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.resource.*;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import static java.lang.String.valueOf;


/**
 * @see RuntimeResourcePack
 * @deprecated internal
 */
@Deprecated
@ApiStatus.Internal
public class RuntimeResourcePackImpl extends class_3255 implements RuntimeResourcePack {
	public static final ExecutorService EXECUTOR_SERVICE;
	public static final boolean DUMP;
	public static final boolean DEBUG_PERFORMANCE;

	// @formatter:off
	public static final Gson GSON = new GsonBuilder()
									.setPrettyPrinting()
									.disableHtmlEscaping()
									.registerTypeAdapter(JTextures.class, new JTextures.Serializer())
									.registerTypeAdapter(JAnimation.class, new JAnimation.Serializer())
									.create();
	// if it works, don't touch it
	static final Set<String> KEY_WARNINGS = Collections.newSetFromMap(new ConcurrentHashMap<>());
	// @formatter:on
	public static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger("RRP");

	static {
		Properties properties = new Properties();
		int processors = Math.max(Runtime.getRuntime().availableProcessors() / 2 - 1, 1);
		boolean dump = false;
		boolean performance = false;
		properties.setProperty("threads", valueOf(processors));
		properties.setProperty("dump assets", "false");
		properties.setProperty("debug performance", "false");

		File file = new File("config/rrp.properties");
		try (FileReader reader = new FileReader(file)) {
			properties.load(reader);
			processors = Integer.parseInt(properties.getProperty("threads"));
			dump = Boolean.parseBoolean(properties.getProperty("dump assets"));
			performance = Boolean.parseBoolean(properties.getProperty("debug performance"));
		} catch (Throwable t) {
			LOGGER.warn("Invalid config, creating new one!");
			file.getParentFile().mkdirs();
			try (FileWriter writer = new FileWriter(file)) {
				properties.store(writer, "number of threads RRP should use for generating resources");
			} catch (IOException ex) {
				LOGGER.error("Unable to write to RRP config!");
				ex.printStackTrace();
			}
		}
		EXECUTOR_SERVICE = Executors.newFixedThreadPool(
				processors,
				new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ARRP-Workers-%s").build()
		);
		DUMP = dump;
		DEBUG_PERFORMANCE = performance;
		KEY_WARNINGS.add("filter");
		KEY_WARNINGS.add("language");
	}

	private final class_2960 id;
	private final Lock waiting = new ReentrantLock();
	private final Map<class_2960, Supplier<byte[]>> data = new ConcurrentHashMap<>();
	private final Map<class_2960, Supplier<byte[]>> assets = new ConcurrentHashMap<>();
	private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<>();
	private final Map<class_2960, JLang> langMergable = new ConcurrentHashMap<>();

	public RuntimeResourcePackImpl(class_2960 id) {
		super(new class_9224(id.method_12836() + ";" + id.method_12832(), class_2561.method_30163("Runtime Resource Pack " + id), class_5352.field_25347, Optional.empty()));
		this.id = id;
	}

	@Override
	public void addRecoloredImage(class_2960 identifier, InputStream target, IntUnaryOperator operator) {
		this.addLazyResource(class_3264.field_14188, fix(identifier, "textures", "png"), (i, r) -> {
			try {

				// optimize buffer allocation, input and output image after recoloring should be roughly the same size
				CountingInputStream is = new CountingInputStream(target);
				// repaint image
				BufferedImage base = ImageIO.read(is);
				BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), BufferedImage.TYPE_INT_ARGB);
				for (int y = 0; y < base.getHeight(); y++) {
					for (int x = 0; x < base.getWidth(); x++) {
						recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
					}
				}
				// write image
				UnsafeByteArrayOutputStream baos = new UnsafeByteArrayOutputStream(is.bytes());
				ImageIO.write(recolored, "png", baos);
				return baos.getBytes();
			} catch (Throwable e) {
				e.printStackTrace();
				throw new RuntimeException(e);
			}
		});
	}

	@Override
	public byte[] addLang(class_2960 identifier, JLang lang) {
		return this.addAsset(fix(identifier, "lang", "json"), serialize(lang.getLang()));
	}

	@Override
	public void mergeLang(class_2960 identifier, JLang lang) {
		this.langMergable.compute(identifier, (identifier1, lang1) -> {
			if (lang1 == null) {
				lang1 = new JLang();
				JLang finalLang = lang1;
				this.addLazyResource(class_3264.field_14188, identifier, (pack, identifier2) -> {
					return pack.addLang(identifier, finalLang);
				});
			}
			lang1.getLang().putAll(lang.getLang());
			return lang1;
		});
	}

	@Override
	public byte[] addLootTable(class_2960 identifier, JLootTable table) {
		return this.addData(fix(identifier, "loot_table", "json"), JsonBytes.encodeToPrettyBytes(JLootTable.CODEC, table));
	}

	@Override
	public Future<byte[]> addAsyncResource(class_3264 type, class_2960 path, CallableFunction<class_2960, byte[]> data) {
		Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> data.get(path));
		this.getSys(type).put(path, () -> {
			try {
				return future.get();
			} catch (InterruptedException | ExecutionException e) {
				throw new RuntimeException(e);
			}
		});
		return future;
	}

	@Override
	public void addLazyResource(class_3264 type, class_2960 path, BiFunction<RuntimeResourcePack, class_2960, byte[]> func) {
		this.getSys(type).put(path, new Memoized<>(func, path));
	}

	@Override
	public byte[] addResource(class_3264 type, class_2960 path, byte[] data) {
		this.getSys(type).put(path, () -> data);
		return data;
	}

	@Override
	public Future<byte[]> addAsyncRootResource(String path, CallableFunction<String, byte[]> data) {
		Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> data.get(path));
		this.root.put(Arrays.asList(path.split("/")), () -> {
			try {
				return future.get();
			} catch (InterruptedException | ExecutionException e) {
				throw new RuntimeException(e);
			}
		});
		return future;
	}

	@Override
	public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
		this.root.put(Arrays.asList(path.split("/")), new Memoized<>(data, path));
	}

	@Override
	public byte[] addRootResource(String path, byte[] data) {
		this.root.put(Arrays.asList(path.split("/")), () -> data);
		return data;
	}

	@Override
	public byte[] addAsset(class_2960 path, byte[] data) {
		return this.addResource(class_3264.field_14188, path, data);
	}

	@Override
	public byte[] addData(class_2960 path, byte[] data) {
		return this.addResource(class_3264.field_14190, path, data);
	}

	@Override
	public byte[] addAdvancement(JAdvancement advancement, class_2960 path) {
		return this.addData(fix(id, "advancement", "json"), JsonBytes.encodeToPrettyBytes(JAdvancement.CODEC, advancement));
	}

	@Override
	public byte[] addModel(JModel model, class_2960 path) {
		return this.addAsset(fix(path, "models", "json"), serialize(model));
	}

	@Override
	public byte[] addItemModelInfo(JItemInfo model, class_2960 path) {
		return this.addAsset(fix(path, "items", "json"), JsonBytes.encodeToPrettyBytes(JItemInfo.CODEC, model));
	}

	@Override
	public byte[] addEquipmentModel(JEquipmentModel model, class_2960 path) {
		return this.addAsset(fix(path, "equipment", "json"), JsonBytes.encodeToPrettyBytes(JEquipmentModel.CODEC, model));
	}

	@Override
	public byte[] addBlockState(JState state, class_2960 path) {
		return this.addAsset(fix(path, "blockstates", "json"), JsonBytes.encodeToPrettyBytes(JState.CODEC, state));
	}

	@Override
	public byte[] addTexture(class_2960 id, BufferedImage image) {
		UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
		try {
			ImageIO.write(image, "png", ubaos);
		} catch (IOException e) {
			throw new RuntimeException("impossible.", e);
		}
		return this.addAsset(fix(id, "textures", "png"), ubaos.getBytes());
	}

	@Override
	public byte[] addAnimation(class_2960 id, JAnimation animation) {
		return this.addAsset(fix(id, "textures", "png.mcmeta"), serialize(animation));
	}

	@Override
	public byte[] addTag(class_2960 id, JTag tag) {
		return this.addData(fix(id, "tags", "json"), JsonBytes.encodeToPrettyBytes(JTag.CODEC, tag));
	}

	@Override
	public byte[] addRecipe(class_2960 id, JRecipe recipe) {
		return this.addData(fix(id, "recipe", "json"), JsonBytes.encodeToPrettyBytes(JRecipe.CODEC, recipe));
	}

	@Override
	public byte[] addTimeline(class_2960 id, JTimeline timeline) {
		return this.addData(fix(id, "timelines", "json"), JsonBytes.encodeToPrettyBytes(JTimeline.CODEC, timeline));
	}

	@Override
	public byte[] addBiome(class_2960 id, JBiome biome) {
		return this.addData(fix(id, "worldgen/biome", "json"), JsonBytes.encodeToPrettyBytes(JBiome.CODEC, biome));
	}

	@Override
	public byte[] addDimension(class_2960 id, JDimension dimension) {
		return this.addData(fix(id, "dimension", "json"), JsonBytes.encodeToPrettyBytes(JDimension.CODEC, dimension));
	}

	@Override
	public byte[] addDimensionType(class_2960 id, JDimensionType dimensionType) {
		return this.addData(fix(id, "dimension_type", "json"), JsonBytes.encodeToPrettyBytes(JDimensionType.CODEC, dimensionType));
	}

	@Override
	public byte[] addConfiguredFeature(class_2960 id, JConfiguredFeature configuredFeature) {
		return this.addData(fix(id, "worldgen/configured_feature", "json"), JsonBytes.encodeToPrettyBytes(JConfiguredFeature.CODEC, configuredFeature));
	}

	@Override
	public byte[] addPlacedFeature(class_2960 id, JPlacedFeature placedFeature) {
		return this.addData(fix(id, "worldgen/placed_feature", "json"), JsonBytes.encodeToPrettyBytes(JPlacedFeature.CODEC, placedFeature));
	}

	@Override
	public byte[] addNoiseSettings(class_2960 id, JNoiseSettings noiseSettings) {
		return this.addData(fix(id, "worldgen/noise_settings", "json"), JsonBytes.encodeToPrettyBytes(JNoiseSettings.CODEC, noiseSettings));
	}

	@Override
	public byte[] addStructure(class_2960 id, JStructure structure) {
		return this.addData(fix(id, "worldgen/structure", "json"), JsonBytes.encodeToPrettyBytes(JStructure.CODEC, structure));
	}

	@Override
	public byte[] addStructureSet(class_2960 id, JStructureSet structureSet) {
		return this.addData(fix(id, "worldgen/structure_set", "json"), JsonBytes.encodeToPrettyBytes(JStructureSet.CODEC, structureSet));
	}

	@Override
	public Future<?> async(Consumer<RuntimeResourcePack> action) {
		this.lock();
		return EXECUTOR_SERVICE.submit(() -> {
			action.accept(this);
			this.waiting.unlock();
		});
	}

	@Override
	public void dumpDirect(Path output) {
		LOGGER.info("dumping {}'s assets and data", this.id);
		// data dump time
		try {
			for (Map.Entry<List<String>, Supplier<byte[]>> e : this.root.entrySet()) {
				String pathStr = String.join("/", e.getKey());
				Path path = output.resolve(pathStr);
				if (path.toAbsolutePath().startsWith(output.toAbsolutePath())) {
					Files.createDirectories(path.getParent());
					Files.write(path, e.getValue().get());
				} else {
					LOGGER.error("RRP contains out-of-directory path! \"{}\"", pathStr);
				}
			}

			Path assets = output.resolve("assets");
			Files.createDirectories(assets);
			for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.assets.entrySet()) {
				this.write(assets, entry.getKey(), entry.getValue().get());
			}

			Path data = output.resolve("data");
			Files.createDirectories(data);
			for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.data.entrySet()) {
				this.write(data, entry.getKey(), entry.getValue().get());
			}
		} catch (IOException exception) {
			throw new RuntimeException(exception);
		}
	}

	@Override
	public void load(Path dir) throws IOException {
		try (Stream<Path> stream = Files.walk(dir)) {
			for (Path file : (Iterable<Path>) () -> stream.filter(Files::isRegularFile).map(dir::relativize).iterator()) {
				String s = file.toString();
				if (s.startsWith("assets")) {
					String path = s.substring("assets".length() + 1);
					this.load(path, this.assets, Files.readAllBytes(file));
				} else if (s.startsWith("data")) {
					String path = s.substring("data".length() + 1);
					this.load(path, this.data, Files.readAllBytes(file));
				} else {
					byte[] data = Files.readAllBytes(file);
					this.root.put(Arrays.asList(s.split("/")), () -> data);
				}
			}
		}
	}

	@Override
	public void dump(ZipOutputStream zos) throws IOException {
		this.lock();
		for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
			zos.putNextEntry(new ZipEntry(String.join("/", entry.getKey())));
			zos.write(entry.getValue().get());
			zos.closeEntry();
		}

		for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.assets.entrySet()) {
			class_2960 id = entry.getKey();
			zos.putNextEntry(new ZipEntry("assets/" + id.method_12836() + "/" + id.method_12832()));
			zos.write(entry.getValue().get());
			zos.closeEntry();
		}

		for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.data.entrySet()) {
			class_2960 id = entry.getKey();
			zos.putNextEntry(new ZipEntry("data/" + id.method_12836() + "/" + id.method_12832()));
			zos.write(entry.getValue().get());
			zos.closeEntry();
		}
		this.waiting.unlock();
	}

	@Override
	public void load(ZipInputStream stream) throws IOException {
		ZipEntry entry;
		while ((entry = stream.getNextEntry()) != null) {
			String s = entry.toString();
			if (s.startsWith("assets")) {
				String path = s.substring("assets".length() + 1);
				this.load(path, this.assets, this.read(entry, stream));
			} else if (s.startsWith("data")) {
				String path = s.substring("data".length() + 1);
				this.load(path, this.data, this.read(entry, stream));
			} else {
				byte[] data = this.read(entry, stream);
				this.root.put(Arrays.asList(s.split("/")), () -> data);
			}
		}
	}

	/**
	 * pack.png and that's about it I think/hope
	 *
	 * @param segments the name of the file, can't be a path tho
	 * @return the pack.png image as a stream
	 */
	@Override
	public class_7367<InputStream> method_14410(String... segments) {
		this.lock();
		Supplier<byte[]> supplier = this.root.get(Arrays.asList(segments));
		if (supplier == null) {
			this.waiting.unlock();
			return null;
		}
		this.waiting.unlock();
		return () -> new ByteArrayInputStream(supplier.get());
	}

	@Override
	public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
		this.lock();
		Supplier<byte[]> supplier = this.getSys(type).get(id);
		if (supplier == null) {
			//LOGGER.warn("No resource found for " + id);
			this.waiting.unlock();
			return null;
		}
		this.waiting.unlock();
		return () -> new ByteArrayInputStream(supplier.get());
	}

	@Override
	public void method_14408(class_3264 type, String namespace, String prefix, class_7664 consumer) {
		this.lock();
		for (class_2960 identifier : this.getSys(type).keySet()) {
			Supplier<byte[]> supplier = this.getSys(type).get(identifier);
			if (supplier == null) {
				//LOGGER.warn("No resource found for " + identifier);
				this.waiting.unlock();
				continue;
			}
			class_7367<InputStream> inputSupplier = () -> new ByteArrayInputStream(supplier.get());
			if (identifier.method_12836().equals(namespace) && identifier.method_12832().startsWith(prefix)) {
				consumer.accept(identifier, inputSupplier);
			}
		}
		this.waiting.unlock();
	}

	@Override
	public Set<String> method_14406(class_3264 type) {
		this.lock();
		Set<String> namespaces = new HashSet<>();
		for (class_2960 identifier : this.getSys(type).keySet()) {
			namespaces.add(identifier.method_12836());
		}
		this.waiting.unlock();
		return namespaces;
	}

	@Override
	public void close() {
		LOGGER.info("closing rrp {}", this.id);

		// lock
		this.lock();
		if (DUMP) {
			this.dump();
		}

		// unlock
		this.waiting.unlock();
	}

	private static byte[] serialize(Object object) {
		UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
		OutputStreamWriter writer = new OutputStreamWriter(ubaos, StandardCharsets.UTF_8);
		GSON.toJson(object, writer);
		try {
			writer.close();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		return ubaos.getBytes();
	}

	private static class_2960 fix(class_2960 identifier, String prefix, String append) {
		return class_2960.method_60655(identifier.method_12836(), prefix + '/' + identifier.method_12832() + '.' + append);
	}

	protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
		byte[] data = new byte[Math.toIntExact(entry.getSize())];
		if (stream.read(data) != data.length) {
			throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
		}
		return data;
	}

	protected void load(String fullPath, Map<class_2960, Supplier<byte[]>> map, byte[] data) {
		int sep = fullPath.indexOf('/');
		String namespace = fullPath.substring(0, sep);
		String path = fullPath.substring(sep + 1);
		map.put(class_2960.method_60655(namespace, path), () -> data);
	}

	private void lock() {
		if (!this.waiting.tryLock()) {
			if (DEBUG_PERFORMANCE) {
				long start = System.currentTimeMillis();
				this.waiting.lock();
				long end = System.currentTimeMillis();
				LOGGER.warn("waited " + (end - start) + "ms for lock in RRP: " + this.id);
			} else {
				this.waiting.lock();
			}
		}
	}

	private void write(Path dir, class_2960 identifier, byte[] data) {
		try {
			String namespace = identifier.method_12836();
			String path = identifier.method_12832();
			Path file = dir.resolve(namespace).resolve(path);
			if (file.toAbsolutePath().startsWith(dir.toAbsolutePath())) {
				Files.createDirectories(file.getParent());
				try (OutputStream output = Files.newOutputStream(file)) {
					output.write(data);
				}
			} else {
				LOGGER.error("RRP contains out-of-directory location! \"" + namespace + "/" + path + "\"");
			}

		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	private Map<class_2960, Supplier<byte[]>> getSys(class_3264 side) {
		return side == class_3264.field_14188 ? this.assets : this.data;
	}

	private class Memoized<T> implements Supplier<byte[]> {
		private final BiFunction<RuntimeResourcePack, T, byte[]> func;
		private final T path;
		private byte[] data;

		public Memoized(BiFunction<RuntimeResourcePack, T, byte[]> func, T path) {
			this.func = func;
			this.path = path;
		}

		@Override
		public byte[] get() {
			if (this.data == null) {
				this.data = func.apply(RuntimeResourcePackImpl.this, path);
			}
			return this.data;
		}
	}
}
