package net.devtech.arrp.json.recipe;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public class JResult {
	public static final Codec<JResult> OBJECT_CODEC = RecordCodecBuilder.create(i -> i.group(
			class_2960.field_25139.fieldOf("item").forGetter(r -> r.item),
			// count is OPTIONAL; only present for stacks
			Codec.INT.optionalFieldOf("count").forGetter(r ->
					(r instanceof JStackedResult s) ? Optional.ofNullable(s.getCount()) : Optional.empty()
			),
			// ✅ components OPTIONAL — don't encode when null
			class_9326.field_49589.optionalFieldOf("components").forGetter(r -> Optional.ofNullable(r.components))
	).apply(i, (id, oc, comps) -> {
		JResult res = oc.isPresent() ? JResult.stackedResult(id, oc.get()) : JResult.result(id);
		comps.ifPresent(res::components);
		return res;
	}));

	public static final Codec<JResult> CODEC = Codec.either(class_2960.field_25139, OBJECT_CODEC).xmap(
			// decode
			e -> e.map(JResult::result, x -> x),
			// encode: compact as string when possible
			r -> {
				boolean hasCount = (r instanceof JStackedResult s) && s.getCount() != null && s.getCount() != 1;
				boolean hasComps = r.components != null && !r.components.method_57848(); // empty() is fine
				return (!hasCount && !hasComps) ? Either.left(r.item) : Either.right(r);
			}
	);

	protected final class_2960 item;
	protected class_9326 components; // NEW

	JResult(final class_2960 id) {
		this.item = id;
	}

	public JResult(class_2960 item, class_9326 components) {
		this.item = item;
		this.components = components;
	}

	public static JResult item(final class_1792 item) {
		return result(class_7923.field_41178.method_10221(item));
	}

	public static JResult result(final class_2960 id) {
		return new JResult(id);
	}

	public static JStackedResult itemStack(final class_1792 item, final int count) {
		return stackedResult(class_7923.field_41178.method_10221(item), count);
	}

	public static JStackedResult stackedResult(final class_2960 id, final int count) {
		final JStackedResult stackedResult = new JStackedResult(id);

		stackedResult.count = count;

		return stackedResult;
	}

	/** Set full component changes. */
	public JResult components(class_9326 changes) {
		this.components = changes;
		return this;
	}

	/** Builder-style convenience. */
	public JResult components(java.util.function.Consumer<class_9326.class_9327> build) {
		class_9326.class_9327 b = class_9326.method_57841();
		build.accept(b);
		this.components = b.method_57852();
		return this;
	}

	public class_2960 getItem() {
		return item;
	}

	public class_9326 getComponents() {
		return components;
	}

	@Override
	protected JResult clone() {
		try {
			return (JResult) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new InternalError(e);
		}
	}
}
