package net.devtech.arrp.mixin;

import net.devtech.arrp.ARRP;
import net.devtech.arrp.api.RRPCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3288;
import net.minecraft.class_3288.class_3289;
import net.minecraft.class_3288.class_7679;
import net.minecraft.class_3288.class_7680;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.resource.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@Mixin(class_3279.class)
public class FileResourcePackProviderMixin {
	@Shadow @Final private class_3264 type;
	private static final Logger ARRP_LOGGER = LogManager.getLogger("ARRP/FileResourcePackProviderMixin");

	private static UnaryOperator<class_2561> getSourceTextSupplier() {
		class_2561 text = class_2561.method_43471("pack.source.runtime");
		return name -> class_2561.method_43469("pack.nameAndSource", name, text).method_27692(class_124.field_1080);
	}

	@Inject(method = "register", at = @At("HEAD"))
	public void register(
		Consumer<class_3288> adder,
		CallbackInfo ci
	) throws ExecutionException, InterruptedException {
		List<class_3262> list = new ArrayList<>();
		ARRP.waitForPregen();
		ARRP_LOGGER.info("ARRP register - before user");
		RRPCallback.BEFORE_USER.invoker().insert(list);

		for (class_3262 pack : list) {
			adder.accept(class_3288.method_45275(
					pack.method_56926(),
					new class_7680() {
						@Override
						public class_3262 method_52425(class_9224 var1, class_7679 var2) {
							return pack;
						}

						@Override
						public class_3262 method_52424(class_9224 var1) {
							return pack;
						}
					},
					this.type,
					new class_9225(true, class_3289.field_14280, false)
			));
		}
	}
}
