/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.devtech.arrp.json.advancement.JCriterion;
import net.devtech.arrp.json.advancement.JDisplay;
import net.devtech.arrp.json.advancement.JRewards;

public final class JAdvancement {
    private static final Codec<Map<String, JCriterion>> CRITERIA = Codec.unboundedMap((Codec)Codec.STRING, JCriterion.CODEC);
    public static final Codec<JAdvancement> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("parent").forGetter(a -> Optional.ofNullable(a.parent)), (App)JDisplay.CODEC.optionalFieldOf("display").forGetter(a -> Optional.ofNullable(a.display)), (App)CRITERIA.fieldOf("criteria").forGetter(a -> a.criteria), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).optionalFieldOf("requirements").forGetter(a -> Optional.ofNullable(a.requirements)), (App)JRewards.CODEC.optionalFieldOf("rewards").forGetter(a -> Optional.ofNullable(a.rewards)), (App)Codec.BOOL.optionalFieldOf("sends_telemetry_event").forGetter(a -> Optional.ofNullable(a.sendsTelemetryEvent))).apply((Applicative)i, (op, od, criteria, oreq, orw, otel) -> {
        JAdvancement a = new JAdvancement();
        a.parent = op.orElse(null);
        a.display = od.orElse(null);
        a.criteria = criteria != null ? criteria : new LinkedHashMap();
        a.requirements = oreq.orElse(null);
        a.rewards = orw.orElse(null);
        a.sendsTelemetryEvent = otel.orElse(null);
        return a;
    })).validate(a -> {
        if ((a.requirements == null || a.requirements.isEmpty()) && !a.criteria.isEmpty()) {
            a.requirements = a.criteria.keySet().stream().map(List::of).toList();
        }
        return a.criteria.isEmpty() ? DataResult.error(() -> "advancement: 'criteria' must not be empty") : DataResult.success((Object)a);
    });
    public String parent;
    public JDisplay display;
    public Map<String, JCriterion> criteria = new LinkedHashMap<String, JCriterion>();
    public List<List<String>> requirements;
    public JRewards rewards;
    public Boolean sendsTelemetryEvent;

    public JAdvancement parent(String id) {
        this.parent = id;
        return this;
    }

    public JAdvancement display(JDisplay d) {
        this.display = d;
        return this;
    }

    public JAdvancement criterion(String key, JCriterion c) {
        this.criteria.put(key, c);
        return this;
    }

    public JAdvancement requirements(List<List<String>> req) {
        this.requirements = req;
        return this;
    }

    public JAdvancement rewards(JRewards r) {
        this.rewards = r;
        return this;
    }

    public JAdvancement telemetry(boolean v) {
        this.sendsTelemetryEvent = v;
        return this;
    }
}

