/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.property;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.devtech.arrp.json.codec.Codecs;

public abstract class JProperty {
    private final String type;
    private static final Map<String, Codec<? extends JProperty>> REGISTRY = new ConcurrentHashMap<String, Codec<? extends JProperty>>();
    public static final Codec<JProperty> CODEC = Codecs.tagged("property", JProperty::getPropertyType, REGISTRY::get);

    protected JProperty(String type) {
        this.type = type;
    }

    public String getPropertyType() {
        return this.type;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("property", this.getPropertyType());
        return json;
    }

    public static void register(String property, MapCodec<? extends JProperty> codec) {
        REGISTRY.put(property, (Codec<? extends JProperty>)codec.codec());
    }
}

