/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.models.JDisplay;
import net.devtech.arrp.json.models.JElement;
import net.devtech.arrp.json.models.JFace;
import net.devtech.arrp.json.models.JFaces;
import net.devtech.arrp.json.models.JOverride;
import net.devtech.arrp.json.models.JPosition;
import net.devtech.arrp.json.models.JRotation;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class JModel
implements Cloneable {
    private String parent;
    private Boolean ambientocclusion;
    private JDisplay display;
    private JTextures textures;
    private List<JElement> elements;
    private List<JOverride> overrides;

    public static JModel modelKeepElements() {
        JModel model = new JModel();
        model.elements = null;
        return model;
    }

    public static JModel modelKeepElements(String parent) {
        JModel model = new JModel();
        model.parent = parent;
        model.elements = null;
        return model;
    }

    public static JModel modelKeepElements(class_2960 identifier) {
        return JModel.modelKeepElements(identifier.toString());
    }

    public static JModel model() {
        return new JModel();
    }

    public static JModel model(String parent) {
        JModel model = new JModel();
        model.parent = parent;
        return model;
    }

    public static JModel model(class_2960 identifier) {
        return JModel.model(identifier.toString());
    }

    public static JOverride override(JCondition predicate, class_2960 model) {
        return new JOverride(predicate, model.toString());
    }

    public static JCondition condition() {
        return new JCondition(null);
    }

    public static JDisplay display() {
        return new JDisplay();
    }

    public static JElement element() {
        return new JElement();
    }

    public static JFace face(String texture) {
        return new JFace(texture);
    }

    public static JFaces faces() {
        return new JFaces();
    }

    public static JPosition position() {
        return new JPosition();
    }

    public static JRotation rotation(class_2350.class_2351 axis) {
        return new JRotation(axis);
    }

    public static JTextures textures() {
        return new JTextures();
    }

    public static JModel cubeAll(String allTex) {
        return JModel.model("minecraft:block/cube_all").textures(JModel.textures().var("all", allTex));
    }

    public static JModel cubeAll(class_2960 allTex) {
        return JModel.cubeAll(allTex.toString());
    }

    public static JModel cube(String down, String up, String north, String south, String west, String east) {
        return JModel.model("minecraft:block/cube").textures(JModel.textures().var("down", down).var("up", up).var("north", north).var("south", south).var("west", west).var("east", east));
    }

    public static JModel cube(class_2960 down, class_2960 up, class_2960 north, class_2960 south, class_2960 west, class_2960 east) {
        return JModel.cube(down.toString(), up.toString(), north.toString(), south.toString(), west.toString(), east.toString());
    }

    public static JModel cubeColumn(String side, String end) {
        return JModel.model("minecraft:block/cube_column").textures(JModel.textures().var("side", side).var("end", end));
    }

    public static JModel cubeColumn(class_2960 side, class_2960 end) {
        return JModel.cubeColumn(side.toString(), end.toString());
    }

    public static JModel cubeBottomTop(String side, String bottom, String top) {
        return JModel.model("minecraft:block/cube_bottom_top").textures(JModel.textures().var("side", side).var("bottom", bottom).var("top", top));
    }

    public static JModel cubeBottomTop(class_2960 side, class_2960 bottom, class_2960 top) {
        return JModel.cubeBottomTop(side.toString(), bottom.toString(), top.toString());
    }

    public static JModel cross(String crossTex) {
        return JModel.model("minecraft:block/cross").textures(JModel.textures().var("cross", crossTex));
    }

    public static JModel cross(class_2960 crossTex) {
        return JModel.cross(crossTex.toString());
    }

    public static JModel itemGenerated(String layer0) {
        return JModel.model("minecraft:item/generated").textures(JModel.textures().var("layer0", layer0));
    }

    public static JModel itemGenerated(class_2960 layer0) {
        return JModel.itemGenerated(layer0.toString());
    }

    public static JModel itemHandheld(String layer0) {
        return JModel.model("minecraft:item/handheld").textures(JModel.textures().var("layer0", layer0));
    }

    public static JModel itemHandheld(class_2960 layer0) {
        return JModel.itemHandheld(layer0.toString());
    }

    public JModel addOverride(JOverride override) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<JOverride>();
        }
        this.overrides.add(override);
        return this;
    }

    public JModel parent(String parent) {
        this.parent = parent;
        return this;
    }

    public JModel ambientOcclusion(boolean enable) {
        this.ambientocclusion = enable ? null : Boolean.FALSE;
        return this;
    }

    public JModel noAmbientOcclusion() {
        this.ambientocclusion = Boolean.FALSE;
        return this;
    }

    public JModel display(JDisplay display) {
        this.display = display;
        return this;
    }

    public JModel textures(JTextures textures) {
        this.textures = textures;
        return this;
    }

    public JModel element(JElement ... elements) {
        if (this.elements == null) {
            this.elements = new ArrayList<JElement>();
        }
        this.elements.addAll(Arrays.asList(elements));
        return this;
    }

    public JModel all(String tex) {
        this.ensureTex().var("all", tex);
        return this;
    }

    public JModel all(class_2960 tex) {
        return this.all(tex.toString());
    }

    public JModel side(String tex) {
        this.ensureTex().var("side", tex);
        return this;
    }

    public JModel side(class_2960 tex) {
        return this.side(tex.toString());
    }

    public JModel top(String tex) {
        this.ensureTex().var("top", tex);
        return this;
    }

    public JModel top(class_2960 tex) {
        return this.top(tex.toString());
    }

    public JModel bottom(String tex) {
        this.ensureTex().var("bottom", tex);
        return this;
    }

    public JModel bottom(class_2960 tex) {
        return this.bottom(tex.toString());
    }

    public JModel end(String tex) {
        this.ensureTex().var("end", tex);
        return this;
    }

    public JModel end(class_2960 tex) {
        return this.end(tex.toString());
    }

    public JModel crossTex(String tex) {
        this.ensureTex().var("cross", tex);
        return this;
    }

    public JModel crossTex(class_2960 tex) {
        return this.crossTex(tex.toString());
    }

    public JModel north(String tex) {
        this.ensureTex().var("north", tex);
        return this;
    }

    public JModel north(class_2960 tex) {
        return this.north(tex.toString());
    }

    public JModel south(String tex) {
        this.ensureTex().var("south", tex);
        return this;
    }

    public JModel south(class_2960 tex) {
        return this.south(tex.toString());
    }

    public JModel west(String tex) {
        this.ensureTex().var("west", tex);
        return this;
    }

    public JModel west(class_2960 tex) {
        return this.west(tex.toString());
    }

    public JModel east(String tex) {
        this.ensureTex().var("east", tex);
        return this;
    }

    public JModel east(class_2960 tex) {
        return this.east(tex.toString());
    }

    public JModel up(String tex) {
        this.ensureTex().var("up", tex);
        return this;
    }

    public JModel up(class_2960 tex) {
        return this.up(tex.toString());
    }

    public JModel down(String tex) {
        this.ensureTex().var("down", tex);
        return this;
    }

    public JModel down(class_2960 tex) {
        return this.down(tex.toString());
    }

    public JModel layer(int index, String tex) {
        this.ensureTex().var("layer" + index, tex);
        return this;
    }

    public JModel layer0(String tex) {
        return this.layer(0, tex);
    }

    public JModel layer(int index, class_2960 tex) {
        return this.layer(index, tex.toString());
    }

    public JModel layer0(class_2960 tex) {
        return this.layer(0, tex.toString());
    }

    private JTextures ensureTex() {
        if (this.textures == null) {
            this.textures = new JTextures();
        }
        return this.textures;
    }

    public JModel clone() {
        try {
            return (JModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

