/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.devtech.arrp.json.recipe.JStackedResult;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public class JResult {
    public static final Codec<JResult> OBJECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("item").forGetter(r -> r.item), (App)Codec.INT.optionalFieldOf("count").forGetter(r -> {
        Optional<Object> optional;
        if (r instanceof JStackedResult) {
            JStackedResult s = (JStackedResult)r;
            optional = Optional.ofNullable(s.getCount());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }), (App)class_9326.field_49589.optionalFieldOf("components").forGetter(r -> Optional.ofNullable(r.components))).apply((Applicative)i, (id, oc, comps) -> {
        JResult res = oc.isPresent() ? JResult.stackedResult(id, (Integer)oc.get()) : JResult.result(id);
        comps.ifPresent(res::components);
        return res;
    }));
    public static final Codec<JResult> CODEC = Codec.either((Codec)class_2960.field_25139, OBJECT_CODEC).xmap(e -> (JResult)e.map(JResult::result, x -> x), r -> {
        JStackedResult s;
        boolean hasCount = r instanceof JStackedResult && (s = (JStackedResult)r).getCount() != null && s.getCount() != 1;
        boolean hasComps = r.components != null && !r.components.method_57848();
        return !hasCount && !hasComps ? Either.left((Object)r.item) : Either.right((Object)r);
    });
    protected final class_2960 item;
    protected class_9326 components;

    JResult(class_2960 id) {
        this.item = id;
    }

    public JResult(class_2960 item, class_9326 components) {
        this.item = item;
        this.components = components;
    }

    public static JResult item(class_1792 item) {
        return JResult.result(class_7923.field_41178.method_10221((Object)item));
    }

    public static JResult result(class_2960 id) {
        return new JResult(id);
    }

    public static JStackedResult itemStack(class_1792 item, int count) {
        return JResult.stackedResult(class_7923.field_41178.method_10221((Object)item), count);
    }

    public static JStackedResult stackedResult(class_2960 id, int count) {
        JStackedResult stackedResult = new JStackedResult(id);
        stackedResult.count = count;
        return stackedResult;
    }

    public JResult components(class_9326 changes) {
        this.components = changes;
        return this;
    }

    public JResult components(Consumer<class_9326.class_9327> build) {
        class_9326.class_9327 b = class_9326.method_57841();
        build.accept(b);
        this.components = b.method_57852();
        return this;
    }

    public class_2960 getItem() {
        return this.item;
    }

    public class_9326 getComponents() {
        return this.components;
    }

    protected JResult clone() {
        try {
            return (JResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

