/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.devtech.arrp.json.worldgen.JAttributeValue;

public class JBiome {
    public static final Codec<JBiome> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_precipitation").forGetter(JBiome::hasPrecipitationOptional), (App)Codec.FLOAT.optionalFieldOf("temperature").forGetter(JBiome::temperatureOptional), (App)Codec.STRING.optionalFieldOf("temperature_modifier").forGetter(JBiome::temperatureModifierOptional), (App)Codec.FLOAT.optionalFieldOf("downfall").forGetter(JBiome::downfallOptional), (App)Effects.CODEC.optionalFieldOf("effects").forGetter(JBiome::effectsOptional), (App)Codec.unboundedMap((Codec)Codec.STRING, JAttributeValue.CODEC).optionalFieldOf("attributes", Collections.emptyMap()).forGetter(b -> b.attributes == null ? Collections.emptyMap() : b.attributes), (App)SpawnSettings.CODEC.optionalFieldOf("spawn_settings").forGetter(JBiome::spawnSettingsOptional), (App)Generation.CODEC.optionalFieldOf("generation").forGetter(JBiome::generationOptional)).apply((Applicative)instance, (precip, temp, tempMod, downfall, effects, attrs, spawn, gen) -> {
        JBiome biome = new JBiome();
        precip.ifPresent(biome::hasPrecipitation);
        temp.ifPresent(biome::temperature);
        tempMod.ifPresent(biome::temperatureModifier);
        downfall.ifPresent(biome::downfall);
        effects.ifPresent(biome::effects);
        biome.attributes((Map<String, JAttributeValue>)attrs);
        spawn.ifPresent(biome::spawnSettings);
        gen.ifPresent(biome::generation);
        return biome;
    }));
    private Boolean hasPrecipitation;
    private Float temperature;
    private String temperatureModifier;
    private Float downfall;
    private Effects effects;
    private Map<String, JAttributeValue> attributes;
    private SpawnSettings spawnSettings;
    private Generation generation;

    public static JBiome biome() {
        return new JBiome();
    }

    public static JBiome empty() {
        return new JBiome();
    }

    private Optional<Boolean> hasPrecipitationOptional() {
        return Optional.ofNullable(this.hasPrecipitation);
    }

    private Optional<Float> temperatureOptional() {
        return Optional.ofNullable(this.temperature);
    }

    private Optional<String> temperatureModifierOptional() {
        return Optional.ofNullable(this.temperatureModifier);
    }

    private Optional<Float> downfallOptional() {
        return Optional.ofNullable(this.downfall);
    }

    private Optional<Effects> effectsOptional() {
        return Optional.ofNullable(this.effects);
    }

    private Optional<Map<String, JAttributeValue>> attributesOptional() {
        return Optional.ofNullable(this.attributes);
    }

    private Optional<SpawnSettings> spawnSettingsOptional() {
        return Optional.ofNullable(this.spawnSettings);
    }

    private Optional<Generation> generationOptional() {
        return Optional.ofNullable(this.generation);
    }

    public JBiome hasPrecipitation(boolean has) {
        this.hasPrecipitation = has;
        return this;
    }

    public JBiome temperature(float temperature) {
        this.temperature = Float.valueOf(temperature);
        return this;
    }

    public JBiome temperatureModifier(String modifier) {
        this.temperatureModifier = modifier;
        return this;
    }

    public JBiome downfall(float downfall) {
        this.downfall = Float.valueOf(downfall);
        return this;
    }

    public JBiome effects(Effects effects) {
        this.effects = effects;
        return this;
    }

    public JBiome attributes(Map<String, JAttributeValue> attributes) {
        this.attributes = attributes;
        return this;
    }

    public JBiome spawnSettings(SpawnSettings spawnSettings) {
        this.spawnSettings = spawnSettings;
        return this;
    }

    public JBiome generation(Generation generation) {
        this.generation = generation;
        return this;
    }

    private Effects ensureEffects() {
        if (this.effects == null) {
            this.effects = new Effects();
        }
        return this.effects;
    }

    private Map<String, JAttributeValue> ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, JAttributeValue>();
        }
        return this.attributes;
    }

    public JBiome attribute(String id, String value) {
        this.ensureAttributes().put(id, JAttributeValue.ofString(value));
        return this;
    }

    public JBiome attribute(String id, Number value) {
        this.ensureAttributes().put(id, JAttributeValue.ofFloat(value.floatValue()));
        return this;
    }

    public JBiome attribute(String id, boolean value) {
        this.ensureAttributes().put(id, JAttributeValue.ofBoolean(value));
        return this;
    }

    private SpawnSettings ensureSpawnSettings() {
        if (this.spawnSettings == null) {
            this.spawnSettings = new SpawnSettings();
        }
        return this.spawnSettings;
    }

    public JBiome spawnProbability(float probability) {
        this.ensureSpawnSettings().setCreatureSpawnProbability(probability);
        return this;
    }

    public static class Effects
    implements Cloneable {
        private String waterColor;
        private String grassColor;
        private String foliageColor;
        private String grassColorModifier;
        public static final Codec<Effects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("water_color").forGetter(e -> Optional.ofNullable(e.waterColor)), (App)Codec.STRING.optionalFieldOf("grass_color").forGetter(e -> Optional.ofNullable(e.grassColor)), (App)Codec.STRING.optionalFieldOf("foliage_color").forGetter(e -> Optional.ofNullable(e.foliageColor)), (App)Codec.STRING.optionalFieldOf("grass_color_modifier").forGetter(e -> Optional.ofNullable(e.grassColorModifier))).apply((Applicative)instance, (water, grass, foliage, modifier) -> {
            Effects e = new Effects();
            water.ifPresent(e::waterColor);
            grass.ifPresent(e::grassColor);
            foliage.ifPresent(e::foliageColor);
            modifier.ifPresent(e::grassColorModifier);
            return e;
        }));

        public Effects waterColor(String color) {
            this.waterColor = color;
            return this;
        }

        public Effects grassColor(String color) {
            this.grassColor = color;
            return this;
        }

        public Effects foliageColor(String color) {
            this.foliageColor = color;
            return this;
        }

        public Effects grassColorModifier(String modifier) {
            this.grassColorModifier = modifier;
            return this;
        }

        public Effects clone() {
            try {
                return (Effects)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }

    public static class SpawnSettings
    implements Cloneable {
        private Float creatureSpawnProbability;
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability").forGetter(s -> Optional.ofNullable(s.creatureSpawnProbability))).apply((Applicative)instance, probOpt -> {
            SpawnSettings s = new SpawnSettings();
            probOpt.ifPresent(s::setCreatureSpawnProbability);
            return s;
        }));

        public SpawnSettings setCreatureSpawnProbability(float probability) {
            this.creatureSpawnProbability = Float.valueOf(probability);
            return this;
        }

        public Float getCreatureSpawnProbability() {
            return this.creatureSpawnProbability;
        }

        public SpawnSettings clone() {
            try {
                return (SpawnSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }

    public static class Generation
    implements Cloneable {
        private List<String> carvers = new ArrayList<String>();
        private List<String> features = new ArrayList<String>();
        public static final Codec<Generation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("carvers", Collections.emptyList()).forGetter(g -> g.carvers == null ? Collections.emptyList() : g.carvers), (App)Codec.STRING.listOf().optionalFieldOf("features", Collections.emptyList()).forGetter(g -> g.features == null ? Collections.emptyList() : g.features)).apply((Applicative)instance, (carvers, features) -> {
            Generation g = new Generation();
            g.carvers = new ArrayList<String>((Collection<String>)carvers);
            g.features = new ArrayList<String>((Collection<String>)features);
            return g;
        }));

        public Generation addCarver(String id) {
            if (id != null) {
                this.carvers.add(id);
            }
            return this;
        }

        public Generation addFeature(String id) {
            if (id != null) {
                this.features.add(id);
            }
            return this;
        }

        public List<String> getCarvers() {
            return Collections.unmodifiableList(this.carvers);
        }

        public List<String> getFeatures() {
            return Collections.unmodifiableList(this.features);
        }

        public Generation clone() {
            try {
                Generation clone = (Generation)super.clone();
                clone.carvers = new ArrayList<String>(this.carvers);
                clone.features = new ArrayList<String>(this.features);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }

    public static abstract class AttributeValue {
        public static final Codec<AttributeValue> CODEC = new Codec<AttributeValue>(){

            public <T> DataResult<T> encode(AttributeValue value, DynamicOps<T> ops, T prefix) {
                if (value instanceof BoolValue) {
                    BoolValue b = (BoolValue)value;
                    return DataResult.success((Object)ops.createBoolean(b.value));
                }
                if (value instanceof NumberValue) {
                    NumberValue n = (NumberValue)value;
                    return DataResult.success((Object)ops.createDouble(n.value));
                }
                if (value instanceof StringValue) {
                    StringValue s = (StringValue)value;
                    return DataResult.success((Object)ops.createString(s.value));
                }
                return DataResult.error(() -> "Unknown AttributeValue subclass: " + String.valueOf(value.getClass()));
            }

            public <T> DataResult<Pair<AttributeValue, T>> decode(DynamicOps<T> ops, T input) {
                Optional boolOpt = ops.getBooleanValue(input).result();
                if (boolOpt.isPresent()) {
                    return DataResult.success((Object)Pair.of((Object)AttributeValue.ofBoolean((Boolean)boolOpt.get()), input));
                }
                Optional numOpt = ops.getNumberValue(input).result();
                if (numOpt.isPresent()) {
                    return DataResult.success((Object)Pair.of((Object)AttributeValue.ofNumber(((Number)numOpt.get()).doubleValue()), input));
                }
                Optional strOpt = ops.getStringValue(input).result();
                if (strOpt.isPresent()) {
                    return DataResult.success((Object)Pair.of((Object)AttributeValue.ofString((String)strOpt.get()), input));
                }
                return DataResult.error(() -> "Unsupported attribute value (not bool/number/string)");
            }
        };

        public static AttributeValue ofBoolean(boolean value) {
            return new BoolValue(value);
        }

        public static AttributeValue ofNumber(double value) {
            return new NumberValue(value);
        }

        public static AttributeValue ofString(String value) {
            return new StringValue(value);
        }

        public static final class BoolValue
        extends AttributeValue {
            public final boolean value;

            public BoolValue(boolean value) {
                this.value = value;
            }
        }

        public static final class NumberValue
        extends AttributeValue {
            public final double value;

            public NumberValue(double value) {
                this.value = value;
            }
        }

        public static final class StringValue
        extends AttributeValue {
            public final String value;

            public StringValue(String value) {
                this.value = value;
            }
        }
    }

    public static class Attributes
    implements Cloneable {
        private final Map<String, AttributeValue> values = new LinkedHashMap<String, AttributeValue>();
        public static final Codec<Attributes> CODEC = Codec.unboundedMap((Codec)Codec.STRING, AttributeValue.CODEC).xmap(Attributes::fromMap, Attributes::toMap);

        private static Attributes fromMap(Map<String, AttributeValue> map) {
            Attributes attrs = new Attributes();
            attrs.values.putAll(map);
            return attrs;
        }

        private Map<String, AttributeValue> toMap() {
            return new LinkedHashMap<String, AttributeValue>(this.values);
        }

        public Attributes putString(String key, String value) {
            if (key != null && value != null) {
                this.values.put(key, AttributeValue.ofString(value));
            }
            return this;
        }

        public Attributes putNumber(String key, double value) {
            if (key != null) {
                this.values.put(key, AttributeValue.ofNumber(value));
            }
            return this;
        }

        public Attributes putBoolean(String key, boolean value) {
            if (key != null) {
                this.values.put(key, AttributeValue.ofBoolean(value));
            }
            return this;
        }

        public Map<String, AttributeValue> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public Attributes skyColorAttr(String hexRgb) {
            return this.putString("minecraft:visual/sky_color", hexRgb);
        }

        public Attributes fogColorAttr(String hexRgb) {
            return this.putString("minecraft:visual/fog_color", hexRgb);
        }

        public Attributes waterFogColorAttr(String hexRgb) {
            return this.putString("minecraft:visual/water_fog_color", hexRgb);
        }

        public Attributes waterFogEndDistance(float radius) {
            return this.putNumber("minecraft:visual/water_fog_start_distance", radius);
        }

        public Attributes waterFogStartDistance(float radius) {
            return this.putNumber("minecraft:visual/water_fog_end_distance", radius);
        }

        public Attributes cloudOpacityAttr(float opacity) {
            return this.putNumber("minecraft:visual/cloud_opacity", opacity);
        }

        public Attributes extraFogAttr(boolean enabled) {
            return this.putBoolean("minecraft:visual/extra_fog", enabled);
        }

        public Attributes waterEvaporatesAttr(boolean evaporates) {
            return this.putBoolean("minecraft:gameplay/water_evaporates", evaporates);
        }

        public Attributes clone() {
            try {
                Attributes clone = (Attributes)super.clone();
                clone.values.clear();
                clone.values.putAll(this.values);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }
}

