/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.api;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.minecraft.class_7367;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ImmediateInputSupplier<T>
extends class_7367<InputStream> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ImmediateInputSupplier.class);

    public T resource();

    public record OfJson(JsonElement jsonElement) implements ImmediateInputSupplier<JsonElement>
    {
        @Override
        public JsonElement resource() {
            return this.jsonElement;
        }

        public InputStream get() throws IOException {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            RuntimeResourcePack.GSON.toJson(this.jsonElement(), (Appendable)new OutputStreamWriter(stream));
            stream.close();
            return new ByteArrayInputStream(stream.toByteArray());
        }
    }

    public record OfSimpleResource<T>(Codec<T> codec, T resource) implements ImmediateInputSupplier<T>
    {
        public InputStream get() throws IOException {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            RuntimeResourcePack.GSON.toJson((Object)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.resource), (Appendable)new OutputStreamWriter(stream));
            stream.close();
            return new ByteArrayInputStream(stream.toByteArray());
        }
    }

    public record OfEmpty<T>(T resource) implements ImmediateInputSupplier<T>
    {
        public InputStream get() throws IOException {
            return InputStream.nullInputStream();
        }
    }
}

