/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2769;

public class JWhen
implements Cloneable {
    private static final Codec<Map<String, String>> AND_OBJECT = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
    private static final Encoder<JWhen> AND_ENCODER = new Encoder<JWhen>(){

        public <T> DataResult<T> encode(JWhen value, DynamicOps<T> ops, T prefix) {
            if (value.state.size() != 1) {
                return DataResult.error(() -> "AND encoder requires exactly one AND-clause, got " + value.state.size());
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (Pair<String, String[]> p : value.state.getFirst()) {
                map.put((String)p.getFirst(), String.join((CharSequence)"|", (CharSequence[])p.getSecond()));
            }
            return AND_OBJECT.encode(map, ops, prefix);
        }
    };
    private static final Decoder<JWhen> AND_DECODER = new Decoder<JWhen>(){

        public <T> DataResult<Pair<JWhen, T>> decode(DynamicOps<T> ops, T input) {
            return AND_OBJECT.decode(ops, input).map(result -> {
                Map m = (Map)result.getFirst();
                JWhen w = new JWhen();
                ArrayList<Pair> clause = new ArrayList<Pair>();
                for (Map.Entry e : m.entrySet()) {
                    String[] stringArray;
                    if (((String)e.getValue()).isEmpty()) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "*";
                    } else {
                        stringArray = ((String)e.getValue()).split("\\|");
                    }
                    String[] vals = stringArray;
                    clause.add(new Pair((Object)((String)e.getKey()), (Object)vals));
                }
                w.state.add(clause);
                return Pair.of((Object)w, (Object)result.getSecond());
            });
        }
    };
    private static final Codec<JWhen> AND_CODEC = Codec.of(AND_ENCODER, AND_DECODER);
    private static final Codec<List<Map<String, String>>> OR_ARRAY_INNER = Codec.list(AND_OBJECT);
    private static final Codec<JWhen> OR_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)OR_ARRAY_INNER.fieldOf("OR").forGetter(w -> {
        ArrayList out = new ArrayList();
        for (List<Pair<String, String[]>> clause : w.state) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            for (Pair<String, String[]> p : clause) {
                m.put((String)p.getFirst(), String.join((CharSequence)"|", (CharSequence[])p.getSecond()));
            }
            out.add(m);
        }
        return out;
    })).apply((Applicative)inst, list -> {
        JWhen w = new JWhen();
        for (Map m : list) {
            ArrayList<Pair> clause = new ArrayList<Pair>();
            for (Map.Entry e : m.entrySet()) {
                String[] stringArray;
                if (((String)e.getValue()).isEmpty()) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                } else {
                    stringArray = ((String)e.getValue()).split("\\|");
                }
                String[] vals = stringArray;
                clause.add(new Pair((Object)((String)e.getKey()), (Object)vals));
            }
            w.state.add(clause);
        }
        return w;
    }));
    public static final Codec<JWhen> CODEC = Codec.either(AND_CODEC, OR_CODEC).xmap(e -> (JWhen)e.map(a -> a, o -> o), w -> w.state.size() == 1 ? Either.left((Object)w) : Either.right((Object)w));
    private final List<List<Pair<String, String[]>>> state = new ArrayList<List<Pair<String, String[]>>>();

    @SafeVarargs
    public final <T extends Comparable<T>> JWhen add(class_2769<T> property, T ... values) {
        String[] states = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            states[i] = property.method_11901(values[i]);
        }
        return this.add(property.method_11899(), states);
    }

    public JWhen add(String condition, String ... states) {
        this.state.add(List.of(new Pair((Object)condition, (Object)states)));
        return this;
    }

    public JWhen add(StateBuilder builder) {
        this.state.add(List.copyOf(builder.state));
        return this;
    }

    public JWhen add(Map<String, ?> props) {
        ArrayList<Pair> clause = new ArrayList<Pair>();
        for (Map.Entry<String, ?> e : props.entrySet()) {
            clause.add(new Pair((Object)e.getKey(), (Object)JWhen.toStates(e.getValue())));
        }
        this.state.add(clause);
        return this;
    }

    public static JWhen of(Map<String, ?> props) {
        return new JWhen().add(props);
    }

    private static String[] toStates(Object v) {
        if (v == null) {
            return new String[]{"null"};
        }
        if (v instanceof String) {
            String s = (String)v;
            return new String[]{s};
        }
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            return new String[]{b.toString()};
        }
        if (v instanceof Enum) {
            Enum en = (Enum)v;
            return new String[]{en.name().toLowerCase(Locale.ROOT)};
        }
        if (v instanceof String[]) {
            String[] stringArray;
            String[] arr = (String[])v;
            if (arr.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            } else {
                stringArray = arr;
            }
            return stringArray;
        }
        if (v instanceof Collection) {
            String[] stringArray;
            Collection col = (Collection)v;
            ArrayList<String> out = new ArrayList<String>(col.size());
            for (Object o : col) {
                out.add(JWhen.first(JWhen.toStates(o)));
            }
            if (out.isEmpty()) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "*";
            } else {
                stringArray = (String[])out.toArray(String[]::new);
            }
            return stringArray;
        }
        return new String[]{v.toString()};
    }

    private static String first(String[] a) {
        return a.length == 0 ? "*" : a[0];
    }

    public JWhen isTrue(String prop) {
        return this.add(prop, "true");
    }

    public JWhen isFalse(String prop) {
        return this.add(prop, "false");
    }

    public JWhen whenProp(String prop, String ... states) {
        return this.add(prop, states);
    }

    public JWhen clone() {
        try {
            return (JWhen)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static class StateBuilder
    implements Cloneable {
        final List<Pair<String, String[]>> state = new ArrayList<Pair<String, String[]>>();

        @SafeVarargs
        public final <T extends Comparable<T>> StateBuilder add(class_2769<T> property, T ... values) {
            String[] states = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                states[i] = property.method_11901(values[i]);
            }
            return this.add(property.method_11899(), states);
        }

        public StateBuilder add(Map<String, ?> props) {
            for (Map.Entry<String, ?> e : props.entrySet()) {
                this.add(e.getKey(), JWhen.toStates(e.getValue()));
            }
            return this;
        }

        public StateBuilder add(String condition, String ... states) {
            this.state.add((Pair<String, String[]>)new Pair((Object)condition, (Object)states));
            return this;
        }

        public StateBuilder isTrue(String prop) {
            return this.add(prop, "true");
        }

        public StateBuilder isFalse(String prop) {
            return this.add(prop, "false");
        }

        public StateBuilder whenProp(String prop, String ... states) {
            return this.add(prop, states);
        }

        protected StateBuilder clone() {
            try {
                return (StateBuilder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }
}

