/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.codec;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class Codecs {
    public static final Codec<JsonElement> JSON = new Codec<JsonElement>(){

        public <T> DataResult<T> encode(JsonElement v, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)v).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            return DataResult.success((Object)Pair.of((Object)el, input));
        }
    };

    private Codecs() {
    }

    public static <T> Codec<List<T>> oneOrList(Codec<T> elem) {
        return Codec.either(elem, (Codec)elem.listOf()).xmap(e -> (List)e.map(List::of, l -> l), l -> l.size() == 1 ? Either.left(l.getFirst()) : Either.right((Object)l));
    }

    public static <B, T> Codec<B> tagged(final String tagKey, final Function<B, T> typeGetter, final Function<T, Codec<? extends B>> lookup, final Codec<T> tagCodec) {
        return Codec.of((Encoder)new Encoder<B>(){

            public <X> DataResult<X> encode(B value, DynamicOps<X> ops, X prefix) {
                Object tag = Objects.requireNonNull(typeGetter.apply(value), "tag is null for " + String.valueOf(value));
                Codec sub = Objects.requireNonNull((Codec)lookup.apply(tag), "no codec for tag: " + String.valueOf(tag));
                DataResult body = sub.encode(value, ops, prefix);
                if (body.result().isEmpty()) {
                    return body;
                }
                DataResult tagNode = tagCodec.encodeStart(ops, tag);
                if (tagNode.result().isEmpty()) {
                    return tagNode;
                }
                return ops.mergeToMap(body.result().get(), ops.createString(tagKey), tagNode.result().get());
            }
        }, (Decoder)new Decoder<B>(){

            public <X> DataResult<Pair<B, X>> decode(DynamicOps<X> ops, X input) {
                DataResult mapRes = ops.getMap(input);
                if (mapRes.result().isEmpty()) {
                    return DataResult.error(() -> "expected object for tagged(" + tagKey + ")");
                }
                Object tagNode = ((MapLike)mapRes.result().get()).get(tagKey);
                if (tagNode == null) {
                    return DataResult.error(() -> "missing '" + tagKey + "'");
                }
                DataResult tagRes = tagCodec.parse(ops, tagNode);
                if (tagRes.result().isEmpty()) {
                    return DataResult.error(() -> "bad '" + tagKey + "'");
                }
                Object tag = tagRes.result().get();
                Codec sub = (Codec)lookup.apply(tag);
                if (sub == null) {
                    return DataResult.error(() -> "unknown tag: " + String.valueOf(tag));
                }
                return sub.decode(ops, input);
            }
        });
    }

    public static <B> Codec<B> tagged(final String tagKey, final Function<B, String> typeGetter, final Function<String, Codec<? extends B>> lookup) {
        return Codec.of((Encoder)new Encoder<B>(){

            public <T> DataResult<T> encode(B value, DynamicOps<T> ops, T prefix) {
                String tag = Objects.requireNonNull((String)typeGetter.apply(value), "tag is null for " + String.valueOf(value));
                Codec sub = Objects.requireNonNull((Codec)lookup.apply(tag), "no codec for tag: " + tag);
                DataResult body = sub.encode(value, ops, prefix);
                return body.flatMap(obj -> ops.mergeToMap(obj, ops.createString(tagKey), ops.createString(tag)));
            }
        }, (Decoder)new Decoder<B>(){

            public <T> DataResult<Pair<B, T>> decode(DynamicOps<T> ops, T input) {
                DataResult mapRes = ops.getMap(input);
                if (mapRes.result().isEmpty()) {
                    return DataResult.error(() -> "expected object for tagged(" + tagKey + ")");
                }
                MapLike map = (MapLike)mapRes.result().get();
                Object tagNode = map.get(tagKey);
                if (tagNode == null) {
                    return DataResult.error(() -> "missing '" + tagKey + "'");
                }
                DataResult s = ops.getStringValue(tagNode);
                if (s.result().isEmpty()) {
                    return DataResult.error(() -> "'" + tagKey + "' must be a string");
                }
                String tag = (String)s.result().get();
                Codec sub = (Codec)lookup.apply(tag);
                if (sub == null) {
                    return DataResult.error(() -> "unknown tag '" + tagKey + "': " + tag);
                }
                return sub.decode(ops, input);
            }
        });
    }
}

