/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.devtech.arrp.json.iteminfo.model.JItemModel;

public class JSelectCase
implements Cloneable {
    private Object when;
    private JItemModel model;
    private static final Codec<Object> PRIMITIVE = Codec.of((Encoder)new Encoder<Object>(){

        public <T> DataResult<T> encode(Object v, DynamicOps<T> ops, T prefix) {
            if (v instanceof String) {
                String s = (String)v;
                return DataResult.success((Object)ops.createString(s));
            }
            if (v instanceof Boolean) {
                Boolean b = (Boolean)v;
                return DataResult.success((Object)ops.createBoolean(b.booleanValue()));
            }
            if (v instanceof Number) {
                Number n = (Number)v;
                if (n instanceof Integer || n instanceof Short || n instanceof Byte) {
                    return DataResult.success((Object)ops.createInt(n.intValue()));
                }
                if (n instanceof Long) {
                    return DataResult.success((Object)ops.createLong(n.longValue()));
                }
                if (n instanceof Float) {
                    return DataResult.success((Object)ops.createFloat(n.floatValue()));
                }
                return DataResult.success((Object)ops.createDouble(n.doubleValue()));
            }
            return DataResult.error(() -> "JSelectCase.when: unsupported value type: " + String.valueOf(v.getClass()));
        }
    }, (Decoder)new Decoder<Object>(){

        public <T> DataResult<Pair<Object, T>> decode(DynamicOps<T> ops, T input) {
            Optional b = ops.getBooleanValue(input).result();
            if (b.isPresent()) {
                return DataResult.success((Object)Pair.of(b.get(), input));
            }
            Optional num = ops.getNumberValue(input).result();
            if (num.isPresent()) {
                Number n = (Number)num.get();
                double d = n.doubleValue();
                if (Math.rint(d) == d) {
                    long L = n.longValue();
                    Long boxed = L >= Integer.MIN_VALUE && L <= Integer.MAX_VALUE ? (long)((int)L) : L;
                    return DataResult.success((Object)Pair.of((Object)boxed, input));
                }
                return DataResult.success((Object)Pair.of((Object)d, input));
            }
            Optional s = ops.getStringValue(input).result();
            return s.map(string -> DataResult.success((Object)Pair.of((Object)string, (Object)input))).orElseGet(() -> DataResult.error(() -> "JSelectCase.when: expected string/number/boolean"));
        }
    });
    private static final Codec<Object> WHEN_CODEC = Codec.either(PRIMITIVE, (Codec)PRIMITIVE.listOf()).xmap(e -> e.map(v -> v, l -> l), o -> {
        Either either;
        if (o instanceof List) {
            List l = (List)o;
            either = Either.right((Object)l);
        } else {
            either = Either.left((Object)o);
        }
        return either;
    });
    public static final Codec<JSelectCase> CODEC = RecordCodecBuilder.create(i -> i.group((App)WHEN_CODEC.fieldOf("when").forGetter(JSelectCase::getWhen), (App)JItemModel.CODEC.fieldOf("model").forGetter(JSelectCase::getModel)).apply((Applicative)i, JSelectCase::new));

    public JSelectCase() {
    }

    public JSelectCase(Object when, JItemModel model) {
        this.when = when;
        this.model = model;
    }

    public static JSelectCase of(Object when, JItemModel model) {
        return new JSelectCase(when, model);
    }

    public Object getWhen() {
        return this.when;
    }

    public JItemModel getModel() {
        return this.model;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.when != null) {
            Object object = this.when;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Number.class, Boolean.class}, (Object)object2, n)) {
                case 0: {
                    String s = (String)object2;
                    json.addProperty("when", s);
                    break;
                }
                case 1: {
                    Number i = (Number)object2;
                    json.addProperty("when", i);
                    break;
                }
                case 2: {
                    Boolean b = (Boolean)object2;
                    json.addProperty("when", b);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type for 'when'");
                }
            }
        }
        if (this.model != null) {
            json.add("model", (JsonElement)this.model.toJson());
        }
        return json;
    }

    public JSelectCase clone() {
        JSelectCase cloned = new JSelectCase();
        cloned.when = this.when;
        cloned.model = this.model != null ? this.model.clone() : null;
        return cloned;
    }
}

