/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.minecraft.class_2960;

public class JCondition
implements Cloneable {
    public static final Codec<JCondition> CODEC = new Codec<JCondition>(){

        public <T> DataResult<T> encode(JCondition v, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)v.parameters).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JCondition, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "Loot condition must be an object");
            }
            JsonObject obj = el.getAsJsonObject();
            JsonElement tag = obj.get("condition");
            if (tag == null || !tag.isJsonPrimitive() || !tag.getAsJsonPrimitive().isString()) {
                return DataResult.error(() -> "Loot condition missing 'condition' string");
            }
            JCondition c = new JCondition();
            c.parameters = obj.deepCopy();
            return DataResult.success((Object)Pair.of((Object)c, input));
        }
    };
    private JsonObject parameters = new JsonObject();

    public JCondition(String condition) {
        if (condition != null) {
            this.condition(condition);
        }
    }

    public JCondition() {
    }

    public JCondition condition(String condition) {
        this.parameters.addProperty("condition", condition);
        return this;
    }

    public JCondition set(JsonObject parameters) {
        parameters.addProperty("condition", this.parameters.get("condition").getAsString());
        this.parameters = parameters;
        return this;
    }

    public JCondition parameter(String key, Number value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JCondition parameter(String key, JsonElement value) {
        this.parameters.add(key, value);
        return this;
    }

    public JCondition parameter(String key, Boolean value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JCondition parameter(String key, Character value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JCondition parameter(String key, class_2960 value) {
        return this.parameter(key, value.toString());
    }

    public JCondition parameter(String key, String value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JCondition alternative(JCondition ... conditions) {
        JsonArray array = new JsonArray();
        for (JCondition condition : conditions) {
            array.add(RuntimeResourcePackImpl.GSON.toJsonTree((Object)condition));
        }
        this.parameters.add("terms", (JsonElement)array);
        return this;
    }

    public JCondition clone() {
        try {
            return (JCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static class Serializer
    implements JsonSerializer<JCondition> {
        public JsonElement serialize(JCondition src, Type typeOfSrc, JsonSerializationContext context) {
            return src.parameters;
        }
    }
}

