/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JLootTable;

public class JEntry
implements Cloneable {
    public static final Codec<JEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("type").forGetter(e -> Optional.ofNullable(e.type)), (App)Codec.STRING.optionalFieldOf("name").forGetter(e -> Optional.ofNullable(e.name)), (App)Codec.BOOL.optionalFieldOf("expand").forGetter(e -> Optional.ofNullable(e.expand)), (App)JFunction.CODEC.listOf().optionalFieldOf("functions").forGetter(e -> Optional.ofNullable(e.functions)), (App)JCondition.CODEC.listOf().optionalFieldOf("conditions").forGetter(e -> Optional.ofNullable(e.conditions)), (App)Codec.INT.optionalFieldOf("weight").forGetter(e -> Optional.ofNullable(e.weight)), (App)Codec.INT.optionalFieldOf("quality").forGetter(e -> Optional.ofNullable(e.quality)), (App)Codec.lazyInitialized(() -> CODEC).listOf().optionalFieldOf("children").forGetter(e -> Optional.ofNullable(e.children))).apply((Applicative)i, (otype, oname, oexp, ofunc, ocond, oweight, oqual, och) -> {
        JEntry e = new JEntry();
        e.type = otype.orElse(null);
        e.name = oname.orElse(null);
        e.expand = oexp.orElse(null);
        e.functions = ofunc.orElse(null);
        e.conditions = ocond.orElse(null);
        e.weight = oweight.orElse(null);
        e.quality = oqual.orElse(null);
        e.children = och.orElse(null);
        return e;
    }));
    private String type;
    private String name;
    private List<JEntry> children;
    private Boolean expand;
    private List<JFunction> functions;
    private List<JCondition> conditions;
    private Integer weight;
    private Integer quality;

    public JEntry type(String type) {
        this.type = type;
        return this;
    }

    public JEntry name(String name) {
        this.name = name;
        return this;
    }

    public JEntry child(JEntry child) {
        if (this == child) {
            throw new IllegalArgumentException("Can't add entry as its own child!");
        }
        if (this.children == null) {
            this.children = new ArrayList<JEntry>();
        }
        this.children.add(child);
        return this;
    }

    public JEntry expand(Boolean expand) {
        this.expand = expand;
        return this;
    }

    public JEntry function(JFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<JFunction>();
        }
        this.functions.add(function);
        return this;
    }

    public JEntry function(String function) {
        return this.function(JLootTable.function(function));
    }

    public JEntry condition(JCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>();
        }
        this.conditions.add(condition);
        return this;
    }

    public JEntry condition(String condition) {
        return this.condition(JLootTable.predicate(condition));
    }

    public JEntry weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public JEntry quality(Integer quality) {
        this.quality = quality;
        return this;
    }

    public JEntry clone() {
        try {
            return (JEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

