/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.json.loot.JCondition;
import net.minecraft.class_2960;

public class JFunction
implements Cloneable {
    public static final Codec<JFunction> CODEC = new Codec<JFunction>(){

        public <T> DataResult<T> encode(JFunction v, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            Object props = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)v.properties).convert(ops).getValue();
            DataResult mapRes = ops.getMap(props);
            if (mapRes.result().isEmpty()) {
                return DataResult.error(() -> "function properties not an object");
            }
            for (Pair e : ((MapLike)mapRes.result().get()).entries().toList()) {
                builder.add(e.getFirst(), e.getSecond());
            }
            if (!v.conditions.isEmpty()) {
                DataResult conds = JCondition.CODEC.listOf().encodeStart(ops, v.conditions);
                if (conds.result().isEmpty()) {
                    return conds;
                }
                builder.add(ops.createString("conditions"), conds.result().get());
            }
            return builder.build(prefix);
        }

        public <T> DataResult<Pair<JFunction, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "loot function must be an object");
            }
            JsonObject obj = el.getAsJsonObject();
            JsonElement fnEl = obj.get("function");
            if (fnEl == null || !fnEl.isJsonPrimitive()) {
                return DataResult.error(() -> "missing 'function'");
            }
            String fn = fnEl.getAsString();
            List conds = List.of();
            JsonElement condEl = obj.remove("conditions");
            if (condEl != null) {
                DataResult parsed = JCondition.CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)condEl);
                if (parsed.result().isEmpty()) {
                    return DataResult.error(() -> "bad function.conditions");
                }
                conds = (List)parsed.result().get();
            }
            JFunction f = new JFunction(fn);
            f.properties = obj;
            f.conditions.addAll(conds);
            return DataResult.success((Object)Pair.of((Object)f, input));
        }
    };
    private final List<JCondition> conditions = new ArrayList<JCondition>();
    private JsonObject properties = new JsonObject();

    public JFunction(String function) {
        this.function(function);
    }

    public JFunction function(String function) {
        this.properties.addProperty("function", function);
        return this;
    }

    public JFunction set(JsonObject properties) {
        properties.addProperty("function", this.properties.get("function").getAsString());
        this.properties = properties;
        return this;
    }

    public JFunction parameter(String key, JsonElement value) {
        this.properties.add(key, value);
        return this;
    }

    public JFunction parameter(String key, String value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JFunction parameter(String key, Number value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JFunction parameter(String key, Boolean value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JFunction parameter(String key, class_2960 value) {
        return this.parameter(key, value.toString());
    }

    public JFunction parameter(String key, Character value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    public JFunction condition(JCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public JFunction clone() {
        try {
            return (JFunction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static class Serializer
    implements JsonSerializer<JFunction> {
        public JsonElement serialize(JFunction src, Type typeOfSrc, JsonSerializationContext context) {
            if (!src.conditions.isEmpty()) {
                src.properties.add("conditions", context.serialize(src.conditions));
            }
            return src.properties;
        }
    }
}

