/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import net.devtech.arrp.json.models.JFace;
import net.devtech.arrp.json.models.JFaces;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JRotation;

public class JElement
implements Cloneable {
    private final float[] from = new float[3];
    private final float[] to = new float[3];
    private JRotation rotation;
    private Boolean shade;
    private JFaces faces;
    private Integer light_emission;

    public JElement from(float x, float y, float z) {
        this.from[0] = JElement.clamp016(x);
        this.from[1] = JElement.clamp016(y);
        this.from[2] = JElement.clamp016(z);
        return this;
    }

    public JElement to(float x, float y, float z) {
        this.to[0] = JElement.clamp016(x);
        this.to[1] = JElement.clamp016(y);
        this.to[2] = JElement.clamp016(z);
        return this;
    }

    public JElement bounds(float fx, float fy, float fz, float tx, float ty, float tz) {
        return this.from(fx, fy, fz).to(tx, ty, tz);
    }

    public JElement rotation(JRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public JElement shade(Boolean shade) {
        this.shade = shade;
        return this;
    }

    public JElement noShade() {
        this.shade = Boolean.FALSE;
        return this;
    }

    public JElement faces(JFaces faces) {
        this.faces = faces;
        return this;
    }

    public JElement light(Integer level) {
        if (level == null) {
            this.light_emission = null;
        } else {
            int clamped = JElement.clamp015(level);
            this.light_emission = clamped;
        }
        return this;
    }

    public JElement emissive() {
        this.light_emission = 15;
        return this;
    }

    public JElement noLight() {
        this.light_emission = null;
        return this;
    }

    private JFaces ensureFaces() {
        if (this.faces == null) {
            this.faces = JModel.faces();
        }
        return this.faces;
    }

    public JElement north(JFace face) {
        this.ensureFaces().north(face);
        return this;
    }

    public JElement south(JFace face) {
        this.ensureFaces().south(face);
        return this;
    }

    public JElement west(JFace face) {
        this.ensureFaces().west(face);
        return this;
    }

    public JElement east(JFace face) {
        this.ensureFaces().east(face);
        return this;
    }

    public JElement up(JFace face) {
        this.ensureFaces().up(face);
        return this;
    }

    public JElement down(JFace face) {
        this.ensureFaces().down(face);
        return this;
    }

    public JElement allFaces(String texVar) {
        JFaces f = this.ensureFaces();
        f.north(JModel.face(texVar));
        f.south(JModel.face(texVar));
        f.west(JModel.face(texVar));
        f.east(JModel.face(texVar));
        f.up(JModel.face(texVar));
        f.down(JModel.face(texVar));
        return this;
    }

    public JElement clone() {
        try {
            JElement c = (JElement)super.clone();
            System.arraycopy(this.from, 0, c.from, 0, 3);
            System.arraycopy(this.to, 0, c.to, 0, 3);
            c.rotation = this.rotation == null ? null : this.rotation.clone();
            c.faces = this.faces == null ? null : this.faces.clone();
            c.shade = this.shade;
            c.light_emission = this.light_emission;
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static float clamp016(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 16.0f) {
            return 16.0f;
        }
        return v;
    }

    private static int clamp015(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 15) {
            return 15;
        }
        return v;
    }
}

