/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;

public record JAttributeValue(Dynamic<?> value) {
    public static final Codec<JAttributeValue> CODEC = Codec.PASSTHROUGH.xmap(JAttributeValue::new, JAttributeValue::raw);

    public static JAttributeValue ofBoolean(boolean v) {
        return JAttributeValue.ofEncoded(Codec.BOOL, v);
    }

    public static JAttributeValue ofDouble(double v) {
        return JAttributeValue.ofEncoded(Codec.DOUBLE, v);
    }

    public static JAttributeValue ofFloat(float v) {
        return JAttributeValue.ofEncoded(Codec.FLOAT, Float.valueOf(v));
    }

    public static JAttributeValue ofInt(int v) {
        return JAttributeValue.ofEncoded(Codec.INT, v);
    }

    public static JAttributeValue ofString(String v) {
        return JAttributeValue.ofEncoded(Codec.STRING, v);
    }

    public static <T> JAttributeValue ofEncoded(Codec<T> codec, T value) {
        DataResult encoded = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value);
        JsonElement raw = (JsonElement)encoded.getOrThrow(msg -> {
            throw new IllegalArgumentException("Failed to encode attribute value: " + msg);
        });
        return new JAttributeValue(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)raw));
    }

    public Dynamic<?> raw() {
        return this.value;
    }

    public <T> T decode(Codec<T> codec) {
        DataResult result = codec.parse(this.value);
        return (T)result.getOrThrow(msg -> {
            throw new IllegalStateException("Failed to decode attribute value: " + msg);
        });
    }
}

