/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.devtech.arrp.json.worldgen.EnvironmentAttributeValue;

public class JEnvironmentAttributes
implements Cloneable {
    private final Map<String, EnvironmentAttributeValue> values = new LinkedHashMap<String, EnvironmentAttributeValue>();
    public static final Codec<JEnvironmentAttributes> CODEC = Codec.unboundedMap((Codec)Codec.STRING, EnvironmentAttributeValue.CODEC).xmap(JEnvironmentAttributes::fromMap, JEnvironmentAttributes::toMap);

    private static JEnvironmentAttributes fromMap(Map<String, EnvironmentAttributeValue> map) {
        JEnvironmentAttributes attrs = new JEnvironmentAttributes();
        attrs.values.putAll(map);
        return attrs;
    }

    private Map<String, EnvironmentAttributeValue> toMap() {
        return new LinkedHashMap<String, EnvironmentAttributeValue>(this.values);
    }

    public JEnvironmentAttributes putString(String key, String value) {
        if (key != null && value != null) {
            this.values.put(key, EnvironmentAttributeValue.ofString(value));
        }
        return this;
    }

    public JEnvironmentAttributes putNumber(String key, double value) {
        if (key != null) {
            this.values.put(key, EnvironmentAttributeValue.ofNumber(value));
        }
        return this;
    }

    public JEnvironmentAttributes putBoolean(String key, boolean value) {
        if (key != null) {
            this.values.put(key, EnvironmentAttributeValue.ofBoolean(value));
        }
        return this;
    }

    public Map<String, EnvironmentAttributeValue> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public EnvironmentAttributeValue get(String key) {
        return this.values.get(key);
    }

    public JEnvironmentAttributes clone() {
        try {
            JEnvironmentAttributes clone = (JEnvironmentAttributes)super.clone();
            clone.values.clear();
            clone.values.putAll(this.values);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

