package net.devtech.arrp.json;

import com.google.gson.*;
import java.lang.reflect.Type;
import net.minecraft.class_2960;

/**
 * Serializes a ResourceLocation as one JSON string ("namespace:path"),
 * and deserializes back from that string.
 */
public class ResourceLocationTypeAdapter implements JsonSerializer<class_2960>, JsonDeserializer<class_2960> {

    @Override
    public JsonElement serialize(class_2960 src, Type typeOfSrc, JsonSerializationContext context) {
        // simply output "namespace:path"
        return new JsonPrimitive(src.toString());
    }

    @Override
    public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        // read "namespace:path"
        if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString()) {
            throw new JsonParseException("Expected ResourceLocation as string");
        }
        return class_2960.method_12829(json.getAsString());
    }
}
