package net.devtech.arrp.json.advancement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

public final class JIcon {
	public static final Codec<JIcon> CODEC = RecordCodecBuilder.create(i -> i.group(
			class_2960.field_25139.fieldOf("item").forGetter(ic -> ic.item),
			Codec.INT.optionalFieldOf("count").forGetter(ic -> Optional.ofNullable(ic.count)),
			class_9326.field_49589.optionalFieldOf("components").forGetter(ic -> Optional.ofNullable(ic.components))
	).apply(i, (item, count, comps) -> {
		JIcon ic = new JIcon();
		ic.item = item;
		ic.count = count.orElse(null);
		ic.components = comps.orElse(null);
		return ic;
	}));

	public class_2960 item;
	public Integer count;                 // optional
	public class_9326 components; // optional (1.20.5+)

	// builder sugar
	public static JIcon of(class_2960 itemId) {
		JIcon ic = new JIcon();
		ic.item = itemId;
		return ic;
	}

	public static JIcon of(class_1792 item) {
		JIcon ic = new JIcon();
		ic.item = class_7923.field_41178.method_10221(item);
		return ic;
	}

	public JIcon count(int c) {
		this.count = c;
		return this;
	}

	public JIcon components(class_9326 p) {
		this.components = p;
		return this;
	}
}
