package net.devtech.arrp;

import net.devtech.arrp.api.ImmediateInputSupplier;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.devtech.arrp.mixin.ResourceAccessor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7367;
import net.minecraft.class_7654;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public interface ResourceExtension {
  static Map<class_2960, Object> findExtendedResources(class_3300 resourceManager, String dataType) {
    final Map<class_2960, Object> map = new HashMap<>();
    class_7654 resourceFinder = class_7654.method_45114(dataType);

    for (Map.Entry<class_2960, class_3298> entry : resourceFinder.method_45113(resourceManager).entrySet()) {
      class_2960 identifier = entry.getKey();

      final class_3298 resource = entry.getValue();
      final class_7367<InputStream> provider = ((ResourceAccessor) resource).getInputSupplier();
      if (provider instanceof ImmediateInputSupplier<?> im) {
        RuntimeResourcePackImpl.LOGGER.debug("ImmediateInputSupplier found: {}", identifier);
        map.put(resourceFinder.method_45115(identifier), im.resource());
      }
    }

    return map;
  }
}