package net.devtech.arrp.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import net.devtech.arrp.JsonSerializers;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.devtech.arrp.json.advancement.JAdvancement;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.equipmentinfo.JEquipmentModel;
import net.devtech.arrp.json.iteminfo.JItemInfo;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.json.timeline.JTimeline;
import net.devtech.arrp.json.worldgen.biome.JBiome;
import net.devtech.arrp.json.worldgen.dimension.JDimension;
import net.devtech.arrp.json.worldgen.dimension.JDimensionType;
import net.devtech.arrp.json.worldgen.feature.JConfiguredFeature;
import net.devtech.arrp.json.worldgen.feature.JPlacedFeature;
import net.devtech.arrp.json.worldgen.noise.JNoiseSettings;
import net.devtech.arrp.json.worldgen.structure.JStructure;
import net.devtech.arrp.json.worldgen.structure.JStructureSet;
import net.devtech.arrp.util.CallableFunction;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/**
 * a resource pack whose assets and data are evaluated at runtime
 * <p>
 * remember to register it!
 * @see RRPCallback
 */
public interface RuntimeResourcePack extends class_3262 {

	/**
	 * The GSONs used to serialize objects to JSON.
	 */
	Gson GSON = new GsonBuilder()
			.registerTypeHierarchyAdapter(class_2960.class, JsonSerializers.IDENTIFIER)
			.registerTypeHierarchyAdapter(class_3542.class, JsonSerializers.STRING_IDENTIFIABLE)
			.registerTypeHierarchyAdapter(Vector3f.class, JsonSerializers.VECTOR_3F)
			.registerTypeHierarchyAdapter(Either.class, JsonSerializers.EITHER)
			.enableComplexMapKeySerialization()
			.disableHtmlEscaping()
			.setPrettyPrinting()
			.create();
	/**
	 * create a new runtime resource pack with the default supported resource pack version
	 */
	@Contract("_ -> new")
	static RuntimeResourcePack create(String id) {
		return new RuntimeResourcePackImpl(class_2960.method_12829(id));
	}

	@Contract("_, _ -> new")
	static RuntimeResourcePack create(String id, int version) {
		return new RuntimeResourcePackImpl(class_2960.method_12829(id));
	}

	@Contract("_ -> new")
	static RuntimeResourcePack create(class_2960 id) {
		return new RuntimeResourcePackImpl(id);
	}

	@Contract("_, _ -> new")
	static RuntimeResourcePack create(class_2960 id, int version) {
		return new RuntimeResourcePackImpl(id);
	}

	static class_2960 id(String string) {return class_2960.method_12829(string);}

	static class_2960 id(String namespace, String string) {return class_2960.method_43902(namespace, string);}


	/**
	 * reads, clones, and recolors the texture at the given path, and puts the newly created image in the given id.
	 *
	 * <b>if your resource pack is registered at a higher priority than where you expect the texture to be in, mc will
	 * be unable to find the asset you are looking for</b>
	 *
	 * @param identifier the place to put the new texture
	 * @param target the input stream of the original texture
	 * @param pixel the pixel recolorer
	 */
	void addRecoloredImage(class_2960 identifier, InputStream target, IntUnaryOperator pixel);

	/**
	 * add a lang file for the given language
	 *
	 * DO **NOT** CALL THIS METHOD MULTIPLE TIMES FOR THE SAME LANGUAGE, THEY WILL OVERRIDE EACH OTHER!
	 * <p>
	 * ex. addLang(MyMod.id("en_us"), lang().translate("something.something", "test"))
	 */
	byte[] addLang(class_2960 identifier, JLang lang);

	/**
	 * Multiple calls to this method with the same identifier will merge them into one lang file
	 */
	void mergeLang(class_2960 identifier, JLang lang);

	/**
	 * adds a loot table
	 */
	byte[] addLootTable(class_2960 identifier, JLootTable table);

	/**
	 * adds an async resource, this is evaluated off-thread, this does not hold all resource retrieval unlike
	 *
	 * @see #async(Consumer)
	 */
	Future<byte[]> addAsyncResource(class_3264 type,
			class_2960 identifier,
			CallableFunction<class_2960, byte[]> data);

	/**
	 * add a resource that is lazily evaluated
	 */
	void addLazyResource(class_3264 type, class_2960 path, BiFunction<RuntimeResourcePack, class_2960, byte[]> data);

	/**
	 * add a raw resource
	 */
	byte[] addResource(class_3264 type, class_2960 path, byte[] data);

	/**
	 * adds an async root resource, this is evaluated off-thread, this does not hold all resource retrieval unlike
	 *
	 * A root resource is something like pack.png, pack.mcmeta, etc. By default ARRP generates a default mcmeta
	 * @see #async(Consumer)
	 */
	Future<byte[]> addAsyncRootResource(String path,
			CallableFunction<String, byte[]> data);

	/**
	 * add a root resource that is lazily evaluated.
	 *
	 * A root resource is something like pack.png, pack.mcmeta, etc. By default ARRP generates a default mcmeta
	 */
	void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data);

	/**
	 * add a raw resource to the root path
	 *
	 * A root resource is something like pack.png, pack.mcmeta, etc. By default, default mcmeta will be generated.
	 */
	byte[] addRootResource(String path, byte[] data);

	/**
	 * add a clientside resource
	 */
	byte[] addAsset(class_2960 path, byte[] data);

	/**
	 * add a serverside resource
	 */
	byte[] addData(class_2960 path, byte[] data);

	/**
	 * add a model, Items should go in item/... and Blocks in block/... ex. mymod:items/my_item ".json" is
	 * automatically
	 * appended to the path
	 */
	byte[] addAdvancement(JAdvancement model, class_2960 path);

	/**
	 * add a model, Items should go in item/... and Blocks in block/... ex. mymod:items/my_item ".json" is
	 * automatically
	 * appended to the path
	 */
	byte[] addModel(JModel model, class_2960 path);

	/**
	 * add a item model info, Goes in items/. mymod:items/my_item ".json" is
	 * automatically
	 * appended to the path
	 */
	byte[] addItemModelInfo(JItemInfo model, class_2960 path);


	/**
	 * Write a vanilla-style equipment‐model JSON to
	 * assets/<namespace>/equipment/<path>.json
	 */
	byte[] addEquipmentModel(JEquipmentModel model, class_2960 path);

	/**
	 * adds a blockstate json
	 * <p>
	 * ".json" is automatically appended to the path
	 */
	byte[] addBlockState(JState state, class_2960 path);

	/**
	 * adds a texture png
	 * <p>
	 * ".png" is automatically appended to the path
	 */
	byte[] addTexture(class_2960 id, BufferedImage image);

	/**
	 * adds an animation json
	 * <p>
	 * ".png.mcmeta" is automatically appended to the path
	 */
	byte[] addAnimation(class_2960 id, JAnimation animation);

	/**
	 * add a tag under the id
	 * <p>
	 * ".json" is automatically appended to the path
	 */
	byte[] addTag(class_2960 id, JTag tag);

	/**
	 * add a recipe
	 * <p>
	 * ".json" is automatically appended to the path
	 *
	 * @param id the {@linkplain class_2960} identifier of the recipe and that represents its directory
	 * @param recipe the recipe to add
	 * @return the new resource
	 */
	byte[] addRecipe(class_2960 id, JRecipe recipe);

	byte[] addTimeline(class_2960 id, JTimeline timeline);

	byte[] addBiome(class_2960 id, JBiome biome);

	byte[] addDimension(class_2960 id, JDimension dimension);

	byte[] addDimensionType(class_2960 id, JDimensionType dimensionType);

	byte[] addConfiguredFeature(class_2960 id, JConfiguredFeature configuredFeature);

	byte[] addPlacedFeature(class_2960 id, JPlacedFeature placedFeature);

	byte[] addNoiseSettings(class_2960 id, JNoiseSettings noiseSettings);

	byte[] addStructure(class_2960 id, JStructure structure);

	byte[] addStructureSet(class_2960 id, JStructureSet structureSet);

	/**
	 * invokes the action on the RRP executor, RRPs are thread-safe you can create expensive assets here, all resources
	 * are blocked until all async tasks are completed invokes the action on the RRP executor, RRPs are thread-safe you
	 * can create expensive assets here, all resources are blocked until all async tasks are completed
	 * <p>
	 * calling an this function from itself will result in a infinite loop
	 *
	 * @see #addAsyncResource(class_3264, class_2960, CallableFunction)
	 */
	Future<?> async(Consumer<RuntimeResourcePack> action);

	Path DEFAULT_OUTPUT = Path.of("rrp.debug");

	/**
	 * forcefully dump all assets and data
	 */
	default void dump() {
		this.dump(DEFAULT_OUTPUT);
	}

	void dumpDirect(Path path);

	void load(Path path) throws IOException;

	/**
	 * forcefully dump all assets and data into `namespace;path/`, useful for debugging
	 */
	default void dump(Path path) {
		String id = this.method_56926().comp_2329();
		Path folder = path.resolve(id);
		this.dumpDirect(folder);
	}

	/**
	 * @see ByteBufOutputStream
	 */
	void dump(ZipOutputStream stream) throws IOException;

	/**
	 * @see ByteBufInputStream
	 */
	void load(ZipInputStream stream) throws IOException;
}
