/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public final class JsonBytes {
    private static final Gson GSON_COMPACT = new GsonBuilder().disableHtmlEscaping().create();
    private static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private JsonBytes() {
    }

    public static <T> JsonElement toJsonElement(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
    }

    public static <T> T fromJsonElement(Codec<T> codec, JsonElement el) {
        return (T)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)el).getOrThrow();
    }

    public static <T> String encodeToString(Codec<T> codec, T value) {
        return JsonBytes.toJsonElement(codec, value).toString();
    }

    public static <T> String encodeToPrettyString(Codec<T> codec, T value) {
        return GSON_PRETTY.toJson(JsonBytes.toJsonElement(codec, value));
    }

    public static <T> T parseFromString(Codec<T> codec, String json) {
        return JsonBytes.fromJsonElement(codec, JsonParser.parseString((String)json));
    }

    public static <T> byte[] encodeToBytes(Codec<T> codec, T value) {
        JsonElement el = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
        return JsonBytes.toBytes(el);
    }

    public static <T> byte[] encodeToPrettyBytes(Codec<T> codec, T value) {
        JsonElement el = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
        return JsonBytes.toPrettyBytes(el);
    }

    public static byte[] toBytes(JsonElement el) {
        return el.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toPrettyBytes(JsonElement el) {
        String json = GSON_PRETTY.toJson(el);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    private static Consumer<String> fail(String phase) {
        return msg -> {
            throw new IllegalStateException("Codec " + phase + " failure: " + msg);
        };
    }
}

