/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.blockstate.JWhen;
import net.devtech.arrp.json.codec.Codecs;
import net.minecraft.class_2960;

public final class JState {
    private static final Codec<List<JVariant>> VARIANTS = Codecs.oneOrList(JVariant.CODEC);
    public static final Codec<JState> CODEC = RecordCodecBuilder.create(i -> i.group((App)VARIANTS.optionalFieldOf("variants").forGetter(s -> s.variants.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(s.variants))), (App)JMultipart.CODEC.listOf().optionalFieldOf("multipart").forGetter(s -> s.multiparts.isEmpty() ? Optional.empty() : Optional.of(List.copyOf(s.multiparts)))).apply((Applicative)i, (ov, om) -> {
        if (ov.isPresent() && om.isPresent()) {
            throw new IllegalStateException("variants XOR multipart");
        }
        JState s = new JState();
        ov.ifPresent(l -> l.forEach(s::add));
        om.ifPresent(l -> l.forEach(s::add));
        return s;
    }));
    private final List<JVariant> variants = new ArrayList<JVariant>();
    private final List<JMultipart> multiparts = new ArrayList<JMultipart>();

    public static JState state() {
        return new JState();
    }

    public static JState state(JVariant ... variants) {
        JState state = new JState();
        for (JVariant variant : variants) {
            state.add(variant);
        }
        return state;
    }

    public static JState state(JMultipart ... parts) {
        JState state = new JState();
        for (JMultipart part : parts) {
            state.add(part);
        }
        return state;
    }

    public static JVariant variant() {
        return new JVariant();
    }

    public static JVariant variant(JBlockModel model) {
        JVariant variant = new JVariant();
        variant.put("", model);
        return variant;
    }

    public static JBlockModel model(class_2960 id) {
        return new JBlockModel(id);
    }

    public static JMultipart multipart(JBlockModel ... models) {
        JMultipart multipart = new JMultipart();
        for (JBlockModel model : models) {
            multipart.addModel(model);
        }
        return multipart;
    }

    public static JWhen when() {
        return new JWhen();
    }

    public static JWhen.StateBuilder whenStateBuilder() {
        return new JWhen.StateBuilder();
    }

    public JState add(JVariant variant) {
        if (!this.multiparts.isEmpty()) {
            throw new IllegalStateException("BlockStates can only have variants *or* multiparts, not both");
        }
        this.variants.add(variant);
        return this;
    }

    public JState add(JMultipart multiparts) {
        if (!this.variants.isEmpty()) {
            throw new IllegalStateException("BlockStates can only have variants *or* multiparts, not both");
        }
        this.multiparts.add(multiparts);
        return this;
    }

    public JState clone() {
        try {
            return (JState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

