/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model.special;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.model.special.JModelSpecial;

public class JModelShield
extends JModelSpecial {
    public static final String TYPE = "minecraft:shield";
    public static final MapCodec<JModelShield> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("pattern").forGetter(s -> Optional.ofNullable(s.pattern)), (App)Codec.STRING.optionalFieldOf("base_texture").forGetter(s -> Optional.ofNullable(s.baseTexture))).apply((Applicative)i, (opPattern, opBase) -> {
        JModelShield s = new JModelShield();
        opPattern.ifPresent(s::pattern);
        opBase.ifPresent(s::baseTexture);
        return s;
    }));
    private String pattern;
    private String baseTexture;

    protected JModelShield() {
        super(TYPE);
    }

    public JModelShield pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public JModelShield baseTexture(String baseTexture) {
        this.baseTexture = baseTexture;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getBaseTexture() {
        return this.baseTexture;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getSpecialType());
        return json;
    }

    @Override
    public JModelShield clone() {
        JModelShield cloned = new JModelShield();
        cloned.base(this.getBase());
        cloned.model(this.getModel() != null ? this.getModel().clone() : null);
        cloned.pattern = this.pattern;
        cloned.baseTexture = this.baseTexture;
        return cloned;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)CODEC.xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }
}

