/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;

public abstract class EnvironmentAttributeValue {
    public static final Codec<EnvironmentAttributeValue> CODEC = new Codec<EnvironmentAttributeValue>(){

        public <T> DataResult<T> encode(EnvironmentAttributeValue value, DynamicOps<T> ops, T prefix) {
            if (value instanceof BoolValue) {
                BoolValue b = (BoolValue)value;
                return DataResult.success((Object)ops.createBoolean(b.value));
            }
            if (value instanceof NumberValue) {
                NumberValue n = (NumberValue)value;
                return DataResult.success((Object)ops.createDouble(n.value));
            }
            if (value instanceof StringValue) {
                StringValue s = (StringValue)value;
                return DataResult.success((Object)ops.createString(s.value));
            }
            return DataResult.error(() -> "Unknown EnvironmentAttributeValue subclass: " + String.valueOf(value.getClass()));
        }

        public <T> DataResult<Pair<EnvironmentAttributeValue, T>> decode(DynamicOps<T> ops, T input) {
            Optional boolOpt = ops.getBooleanValue(input).result();
            if (boolOpt.isPresent()) {
                return DataResult.success((Object)Pair.of((Object)EnvironmentAttributeValue.ofBoolean((Boolean)boolOpt.get()), input));
            }
            Optional numOpt = ops.getNumberValue(input).result();
            if (numOpt.isPresent()) {
                return DataResult.success((Object)Pair.of((Object)EnvironmentAttributeValue.ofNumber(((Number)numOpt.get()).doubleValue()), input));
            }
            Optional strOpt = ops.getStringValue(input).result();
            return strOpt.map(s -> DataResult.success((Object)Pair.of((Object)EnvironmentAttributeValue.ofString(s), (Object)input))).orElseGet(() -> DataResult.error(() -> "Unsupported attribute value (not bool/number/string)"));
        }
    };

    public static EnvironmentAttributeValue ofBoolean(boolean value) {
        return new BoolValue(value);
    }

    public static EnvironmentAttributeValue ofNumber(double value) {
        return new NumberValue(value);
    }

    public static EnvironmentAttributeValue ofString(String value) {
        return new StringValue(value);
    }

    public static final class BoolValue
    extends EnvironmentAttributeValue {
        public final boolean value;

        public BoolValue(boolean value) {
            this.value = value;
        }
    }

    public static final class NumberValue
    extends EnvironmentAttributeValue {
        public final double value;

        public NumberValue(double value) {
            this.value = value;
        }
    }

    public static final class StringValue
    extends EnvironmentAttributeValue {
        public final String value;

        public StringValue(String value) {
            this.value = value;
        }
    }
}

