/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;

public class JStructureSet
implements Cloneable {
    public static final Codec<JStructureSet> CODEC = new Codec<JStructureSet>(){

        public <T> DataResult<T> encode(JStructureSet set, DynamicOps<T> ops, T prefix) {
            JsonObject json = set.toJson();
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JStructureSet, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "Structure set must be an object");
            }
            return DataResult.success((Object)Pair.of((Object)JStructureSet.fromJson(el.getAsJsonObject()), input));
        }
    };
    private JsonArray structures;
    private JsonObject placement;
    private final JsonObject extra = new JsonObject();

    public static JStructureSet set() {
        return new JStructureSet();
    }

    public static JStructureSet fromJson(JsonObject json) {
        return new JStructureSet().json(json);
    }

    public JStructureSet json(JsonObject json) {
        this.structures = null;
        this.placement = null;
        this.extra.entrySet().clear();
        if (json == null) {
            return this;
        }
        if (json.has("structures") && json.get("structures").isJsonArray()) {
            this.structures = json.getAsJsonArray("structures").deepCopy();
        }
        if (json.has("placement") && json.get("placement").isJsonObject()) {
            this.placement = json.getAsJsonObject("placement").deepCopy();
        }
        for (String key : json.keySet()) {
            JsonElement val;
            if (JStructureSet.isKnown(key) || (val = json.get(key)) == null) continue;
            this.extra.add(key, val.deepCopy());
        }
        return this;
    }

    public JStructureSet structures(JsonArray structures) {
        this.structures = structures == null ? null : structures.deepCopy();
        return this;
    }

    public JStructureSet placement(JsonObject placement) {
        this.placement = placement == null ? null : placement.deepCopy();
        return this;
    }

    public JStructureSet extra(String key, JsonElement value) {
        if (key != null && value != null && !JStructureSet.isKnown(key)) {
            this.extra.add(key, value.deepCopy());
        }
        return this;
    }

    private JsonArray ensureStructures() {
        if (this.structures == null) {
            this.structures = new JsonArray();
        }
        return this.structures;
    }

    public JStructureSet addStructure(String id, int weight) {
        JsonObject obj = new JsonObject();
        obj.addProperty("structure", id);
        obj.addProperty("weight", (Number)weight);
        this.ensureStructures().add((JsonElement)obj);
        return this;
    }

    public static JStructureSet randomSpread(String structureId, int weight, int salt, int spacing, int separation) {
        JStructureSet set = JStructureSet.set();
        set.addStructure(structureId, weight);
        JsonObject placement = new JsonObject();
        placement.addProperty("type", "minecraft:random_spread");
        placement.addProperty("salt", (Number)salt);
        placement.addProperty("spacing", (Number)spacing);
        placement.addProperty("separation", (Number)separation);
        set.placement(placement);
        return set;
    }

    public JsonObject toJson() {
        JsonObject out = new JsonObject();
        if (this.structures != null) {
            out.add("structures", (JsonElement)this.structures.deepCopy());
        }
        if (this.placement != null) {
            out.add("placement", (JsonElement)this.placement.deepCopy());
        }
        for (String key : this.extra.keySet()) {
            JsonElement val = this.extra.get(key);
            if (val == null) continue;
            out.add(key, val.deepCopy());
        }
        return out;
    }

    public JStructureSet clone() {
        try {
            JStructureSet clone = (JStructureSet)super.clone();
            clone.structures = this.structures == null ? null : this.structures.deepCopy();
            clone.placement = this.placement == null ? null : this.placement.deepCopy();
            clone.extra.entrySet().clear();
            for (String key : this.extra.keySet()) {
                JsonElement val = this.extra.get(key);
                if (val == null) continue;
                clone.extra.add(key, val.deepCopy());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static boolean isKnown(String key) {
        return "structures".equals(key) || "placement".equals(key);
    }
}

