/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.advancement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class AdvConditions {
    private AdvConditions() {
    }

    public static JsonObject inventoryChanged(ItemPredicate ... anyOf) {
        JsonObject root = new JsonObject();
        if (anyOf != null && anyOf.length > 0) {
            JsonArray items = new JsonArray();
            for (ItemPredicate p : anyOf) {
                items.add((JsonElement)p.toJson());
            }
            root.add("items", (JsonElement)items);
        }
        return root;
    }

    public static JsonObject recipeUnlocked(String recipeId) {
        JsonObject o = new JsonObject();
        o.addProperty("recipe", recipeId);
        return o;
    }

    public static JsonObject placedOrEnterBlock(String key, String blockId, Map<String, String> state) {
        JsonObject o = new JsonObject();
        o.addProperty(key, blockId);
        if (state != null && !state.isEmpty()) {
            JsonObject st = new JsonObject();
            for (Map.Entry<String, String> e : state.entrySet()) {
                st.addProperty(e.getKey(), e.getValue());
            }
            o.add("state", (JsonElement)st);
        }
        return o;
    }

    public static JsonObject location(LocationPredicate p) {
        return p.obj;
    }

    public static JsonObject playerKilledEntity(EntityPredicate entity, DamagePredicate damage) {
        JsonObject o = new JsonObject();
        if (entity != null) {
            o.add("entity", (JsonElement)entity.obj);
        }
        if (damage != null) {
            o.add("killing_blow", (JsonElement)damage.obj);
        }
        return o;
    }

    public static final class ItemPredicate {
        private final JsonObject obj = new JsonObject();

        public static ItemPredicate anyOf(class_2960 ... itemIds) {
            ItemPredicate p = new ItemPredicate();
            JsonArray arr = new JsonArray();
            for (class_2960 id : itemIds) {
                arr.add(id.toString());
            }
            p.obj.add("items", (JsonElement)arr);
            return p;
        }

        public static ItemPredicate anyOf(class_1792 ... itemIds) {
            ItemPredicate p = new ItemPredicate();
            JsonArray arr = new JsonArray();
            for (class_1792 id : itemIds) {
                arr.add(class_7923.field_41178.method_10221((Object)id).toString());
            }
            p.obj.add("items", (JsonElement)arr);
            return p;
        }

        public ItemPredicate countMin(int min) {
            this.ensureCount().addProperty("min", (Number)min);
            return this;
        }

        public ItemPredicate countMax(int max) {
            this.ensureCount().addProperty("max", (Number)max);
            return this;
        }

        public ItemPredicate componentPresent(String id) {
            JsonObject c = this.ensureComponents();
            JsonObject rule = new JsonObject();
            rule.addProperty("present", Boolean.valueOf(true));
            c.add(id, (JsonElement)rule);
            return this;
        }

        public ItemPredicate componentAbsent(String id) {
            JsonObject c = this.ensureComponents();
            JsonObject rule = new JsonObject();
            rule.addProperty("present", Boolean.valueOf(false));
            c.add(id, (JsonElement)rule);
            return this;
        }

        public ItemPredicate componentEquals(class_2960 id, JsonElement value) {
            this.ensureComponents().add(id.toString(), value);
            return this;
        }

        public ItemPredicate componentNumberRange(String id, Double min, Double max) {
            JsonObject range = new JsonObject();
            if (min != null) {
                range.addProperty("min", (Number)min);
            }
            if (max != null) {
                range.addProperty("max", (Number)max);
            }
            this.ensureComponents().add(id, (JsonElement)range);
            return this;
        }

        private JsonObject ensureComponents() {
            if (!this.obj.has("components")) {
                this.obj.add("components", (JsonElement)new JsonObject());
            }
            return this.obj.getAsJsonObject("components");
        }

        private JsonObject ensureCount() {
            if (!this.obj.has("count")) {
                this.obj.add("count", (JsonElement)new JsonObject());
            }
            return this.obj.getAsJsonObject("count");
        }

        public JsonObject toJson() {
            return this.obj;
        }
    }

    public static final class LocationPredicate {
        private final JsonObject obj = new JsonObject();

        public static LocationPredicate create() {
            return new LocationPredicate();
        }

        public LocationPredicate dimension(String id) {
            this.obj.addProperty("dimension", id);
            return this;
        }

        public LocationPredicate biome(String id) {
            this.obj.addProperty("biome", id);
            return this;
        }

        public LocationPredicate structure(String id) {
            this.obj.addProperty("structure", id);
            return this;
        }

        public LocationPredicate position(Double minY, Double maxY) {
            JsonObject pos = this.obj.has("position") ? this.obj.getAsJsonObject("position") : new JsonObject();
            JsonObject y = new JsonObject();
            if (minY != null) {
                y.addProperty("min", (Number)minY);
            }
            if (maxY != null) {
                y.addProperty("max", (Number)maxY);
            }
            pos.add("y", (JsonElement)y);
            this.obj.add("position", (JsonElement)pos);
            return this;
        }
    }

    public static final class EntityPredicate {
        private final JsonObject obj = new JsonObject();

        public static EntityPredicate type(String id) {
            EntityPredicate p = new EntityPredicate();
            p.obj.addProperty("type", id);
            return p;
        }

        public EntityPredicate nbt(String snbt) {
            this.obj.addProperty("nbt", snbt);
            return this;
        }
    }

    public static final class DamagePredicate {
        private final JsonObject obj = new JsonObject();

        public static DamagePredicate source(String id) {
            DamagePredicate d = new DamagePredicate();
            JsonObject src = new JsonObject();
            src.addProperty("tags", id);
            d.obj.add("source", (JsonElement)src);
            return d;
        }

        public DamagePredicate dealtMin(double v) {
            this.ensureDealt().addProperty("min", (Number)v);
            return this;
        }

        private JsonObject ensureDealt() {
            if (!this.obj.has("dealt")) {
                this.obj.add("dealt", (JsonElement)new JsonObject());
            }
            return this.obj.getAsJsonObject("dealt");
        }
    }
}

