/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.devtech.arrp.json.worldgen.JAttributeValue;
import net.minecraft.class_5699;

public class JBiome {
    public static final Codec<JBiome> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(JBiome::hasPrecipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(JBiome::temperature), (App)Codec.STRING.fieldOf("temperature_modifier").forGetter(JBiome::temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(JBiome::downfall), (App)Effects.CODEC.fieldOf("effects").forGetter(JBiome::effects), (App)Codec.unboundedMap((Codec)Codec.STRING, JAttributeValue.CODEC).optionalFieldOf("attributes", Collections.emptyMap()).forGetter(b -> b.attributes == null ? Collections.emptyMap() : b.attributes), (App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability").forGetter(b -> {
        if (b.spawnSettings == null) {
            return Optional.empty();
        }
        Float prob = b.spawnSettings.getCreatureSpawnProbability();
        return prob == null ? Optional.empty() : Optional.of(prob);
    }), (App)Codec.unboundedMap((Codec)Codec.STRING, SpawnSettings.SpawnCost.CODEC).optionalFieldOf("spawn_costs").forGetter(b -> Optional.of(b.spawnSettings == null ? Collections.emptyMap() : b.spawnSettings.getSpawnCosts())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SpawnSettings.SpawnerData.CODEC.listOf()).optionalFieldOf("spawners").forGetter(b -> Optional.of(b.spawnSettings == null ? Collections.emptyMap() : b.spawnSettings.getSpawners())), (App)Codec.STRING.listOf().optionalFieldOf("carvers", Collections.emptyList()).forGetter(b -> {
        if (b.generation == null) {
            return Collections.emptyList();
        }
        return b.generation.getCarvers();
    }), (App)Codec.STRING.listOf().listOf().optionalFieldOf("features", Collections.emptyList()).forGetter(b -> {
        if (b.generation == null) {
            return Collections.emptyList();
        }
        return b.generation.getFeaturesByStep();
    })).apply((Applicative)instance, (precip, temp, tempMod, downfall, effects, attrs, spawnProbOpt, spawnCostsOpt, spawnersOpt, carvers, featuresSteps) -> {
        boolean hasAnySpawn;
        JBiome biome = new JBiome();
        biome.hasPrecipitation((boolean)precip);
        biome.temperature(temp.floatValue());
        biome.temperatureModifier((String)tempMod);
        biome.downfall(downfall.floatValue());
        biome.effects((Effects)effects);
        biome.attributes((Map<String, JAttributeValue>)attrs);
        boolean bl = hasAnySpawn = spawnProbOpt.isPresent() || spawnCostsOpt.isPresent() || spawnersOpt.isPresent();
        if (hasAnySpawn) {
            Map spawners;
            SpawnSettings s = new SpawnSettings();
            spawnProbOpt.ifPresent(s::setCreatureSpawnProbability);
            Map spawnCosts = spawnCostsOpt.orElseGet(Collections::emptyMap);
            if (!spawnCosts.isEmpty()) {
                s.spawnCosts.putAll(spawnCosts);
            }
            if (!(spawners = spawnersOpt.orElseGet(Collections::emptyMap)).isEmpty()) {
                s.spawners.putAll(spawners);
            }
            biome.spawnSettings(s);
        }
        if (!carvers.isEmpty() || !featuresSteps.isEmpty()) {
            Generation g = new Generation();
            for (String c : carvers) {
                g.addCarver(c);
            }
            for (int step = 0; step < featuresSteps.size(); ++step) {
                for (String feat : (List)featuresSteps.get(step)) {
                    g.addFeature(step, feat);
                }
            }
            biome.generation(g);
        }
        return biome;
    }));
    private Boolean hasPrecipitation;
    private Float temperature;
    private String temperatureModifier;
    private Float downfall;
    private Effects effects = null;
    private Map<String, JAttributeValue> attributes;
    private SpawnSettings spawnSettings = new SpawnSettings();
    private Generation generation;

    public JBiome() {
        this.attributes = new HashMap<String, JAttributeValue>();
        this.generation = new Generation();
    }

    public static JBiome biome() {
        return new JBiome();
    }

    public static JBiome empty() {
        return new JBiome();
    }

    private Boolean hasPrecipitation() {
        return this.hasPrecipitation;
    }

    private float temperature() {
        return this.temperature.floatValue();
    }

    private String temperatureModifier() {
        return this.temperatureModifier;
    }

    private float downfall() {
        return this.downfall.floatValue();
    }

    private Effects effects() {
        return this.effects;
    }

    private Optional<Map<String, JAttributeValue>> attributesOptional() {
        return Optional.ofNullable(this.attributes);
    }

    private Optional<SpawnSettings> spawnSettingsOptional() {
        return Optional.ofNullable(this.spawnSettings);
    }

    private Optional<Generation> generationOptional() {
        return Optional.ofNullable(this.generation);
    }

    public JBiome hasPrecipitation(boolean has) {
        this.hasPrecipitation = has;
        return this;
    }

    public JBiome temperature(float temperature) {
        this.temperature = Float.valueOf(temperature);
        return this;
    }

    public JBiome temperatureModifier(String modifier) {
        this.temperatureModifier = modifier;
        return this;
    }

    public JBiome downfall(float downfall) {
        this.downfall = Float.valueOf(downfall);
        return this;
    }

    public JBiome effects(Effects effects) {
        this.effects = effects;
        return this;
    }

    public JBiome attributes(Map<String, JAttributeValue> attributes) {
        this.attributes = attributes;
        return this;
    }

    public JBiome spawnSettings(SpawnSettings spawnSettings) {
        this.spawnSettings = spawnSettings;
        return this;
    }

    public JBiome generation(Generation generation) {
        this.generation = generation;
        return this;
    }

    private Effects ensureEffects() {
        if (this.effects == null) {
            this.effects = new Effects();
        }
        return this.effects;
    }

    private Map<String, JAttributeValue> ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, JAttributeValue>();
        }
        return this.attributes;
    }

    public JBiome attribute(String id, String value) {
        this.ensureAttributes().put(id, JAttributeValue.ofString(value));
        return this;
    }

    public JBiome attribute(String id, Number value) {
        this.ensureAttributes().put(id, JAttributeValue.ofFloat(value.floatValue()));
        return this;
    }

    public JBiome attribute(String id, boolean value) {
        this.ensureAttributes().put(id, JAttributeValue.ofBoolean(value));
        return this;
    }

    private SpawnSettings ensureSpawnSettings() {
        if (this.spawnSettings == null) {
            this.spawnSettings = new SpawnSettings();
        }
        return this.spawnSettings;
    }

    public JBiome spawnProbability(float probability) {
        this.ensureSpawnSettings().setCreatureSpawnProbability(probability);
        return this;
    }

    public JBiome spawnCost(String entityId, double energyBudget, double charge) {
        this.ensureSpawnSettings().addSpawnCost(entityId, energyBudget, charge);
        return this;
    }

    public JBiome spawner(String category, String entityId, int weight, int minCount, int maxCount) {
        this.ensureSpawnSettings().addSpawner(category, entityId, weight, minCount, maxCount);
        return this;
    }

    public static class SpawnSettings
    implements Cloneable {
        private Float creatureSpawnProbability;
        private Map<String, SpawnCost> spawnCosts = new LinkedHashMap<String, SpawnCost>();
        private Map<String, List<SpawnerData>> spawners = new LinkedHashMap<String, List<SpawnerData>>();
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability").forGetter(s -> Optional.ofNullable(s.creatureSpawnProbability)), (App)Codec.unboundedMap((Codec)Codec.STRING, SpawnCost.CODEC).optionalFieldOf("spawn_costs", Collections.emptyMap()).forGetter(s -> s.spawnCosts == null ? Collections.emptyMap() : s.spawnCosts), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SpawnerData.CODEC.listOf()).optionalFieldOf("spawners", Collections.emptyMap()).forGetter(s -> s.spawners == null ? Collections.emptyMap() : s.spawners)).apply((Applicative)instance, (probOpt, spawnCosts, spawners) -> {
            SpawnSettings s = new SpawnSettings();
            probOpt.ifPresent(s::setCreatureSpawnProbability);
            if (!spawnCosts.isEmpty()) {
                s.spawnCosts.putAll((Map<String, SpawnCost>)spawnCosts);
            }
            if (!spawners.isEmpty()) {
                s.spawners.putAll((Map<String, List<SpawnerData>>)spawners);
            }
            return s;
        }));

        public SpawnSettings setCreatureSpawnProbability(float probability) {
            this.creatureSpawnProbability = Float.valueOf(probability);
            return this;
        }

        public Float getCreatureSpawnProbability() {
            return this.creatureSpawnProbability;
        }

        public Map<String, SpawnCost> getSpawnCosts() {
            return Collections.unmodifiableMap(this.spawnCosts);
        }

        public Map<String, List<SpawnerData>> getSpawners() {
            return Collections.unmodifiableMap(this.spawners);
        }

        public SpawnSettings addSpawnCost(String entityId, double energyBudget, double charge) {
            if (entityId != null) {
                this.spawnCosts.put(entityId, new SpawnCost(energyBudget, charge));
            }
            return this;
        }

        public SpawnSettings addSpawner(String category, String entityId, int weight, int minCount, int maxCount) {
            if (category == null || entityId == null) {
                return this;
            }
            this.spawners.computeIfAbsent(category, k -> new ArrayList()).add(new SpawnerData(entityId, weight, minCount, maxCount));
            return this;
        }

        public SpawnSettings clone() {
            try {
                SpawnSettings clone = (SpawnSettings)super.clone();
                clone.creatureSpawnProbability = this.creatureSpawnProbability;
                clone.spawnCosts = new LinkedHashMap<String, SpawnCost>();
                if (this.spawnCosts != null) {
                    clone.spawnCosts.putAll(this.spawnCosts);
                }
                clone.spawners = new LinkedHashMap<String, List<SpawnerData>>();
                if (this.spawners != null) {
                    for (Map.Entry<String, List<SpawnerData>> e : this.spawners.entrySet()) {
                        clone.spawners.put(e.getKey(), new ArrayList(e.getValue()));
                    }
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }

        public static class SpawnCost {
            public final double energyBudget;
            public final double charge;
            public static final Codec<SpawnCost> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(c -> c.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(c -> c.charge)).apply((Applicative)instance, SpawnCost::new));

            public SpawnCost(double energyBudget, double charge) {
                this.energyBudget = energyBudget;
                this.charge = charge;
            }
        }

        public static class SpawnerData {
            public final String type;
            public final int weight;
            public final int minCount;
            public final int maxCount;
            public static final Codec<SpawnerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(d -> d.type), (App)Codec.INT.fieldOf("weight").forGetter(d -> d.weight), (App)Codec.INT.fieldOf("minCount").forGetter(d -> d.minCount), (App)Codec.INT.fieldOf("maxCount").forGetter(d -> d.maxCount)).apply((Applicative)instance, SpawnerData::new));

            public SpawnerData(String type, int weight, int minCount, int maxCount) {
                this.type = type;
                this.weight = weight;
                this.minCount = minCount;
                this.maxCount = maxCount;
            }
        }
    }

    public static class Effects
    implements Cloneable {
        private int waterColor;
        private int grassColor;
        private int foliageColor;
        private int dryFoliageColor;
        private String grassColorModifier;
        public static final Codec<Effects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_63682.fieldOf("water_color").forGetter(e -> e.waterColor), (App)class_5699.field_63682.optionalFieldOf("grass_color").forGetter(e -> Optional.of(e.grassColor)), (App)class_5699.field_63682.optionalFieldOf("foliage_color").forGetter(e -> Optional.of(e.foliageColor)), (App)class_5699.field_63682.optionalFieldOf("dry_foliage_color").forGetter(e -> Optional.of(e.dryFoliageColor)), (App)Codec.STRING.optionalFieldOf("grass_color_modifier").forGetter(e -> Optional.ofNullable(e.grassColorModifier))).apply((Applicative)instance, (water, grass, foliage, dryFoliage, modifier) -> {
            Effects e = new Effects();
            e.waterColor((int)water);
            grass.ifPresent(e::grassColor);
            foliage.ifPresent(e::foliageColor);
            dryFoliage.ifPresent(e::dryFoliageColor);
            modifier.ifPresent(e::grassColorModifier);
            return e;
        }));

        public Effects waterColor(int color) {
            this.waterColor = color;
            return this;
        }

        public Effects grassColor(int color) {
            this.grassColor = color;
            return this;
        }

        public Effects foliageColor(int color) {
            this.foliageColor = color;
            return this;
        }

        public Effects dryFoliageColor(int color) {
            this.dryFoliageColor = color;
            return this;
        }

        public Effects grassColorModifier(String modifier) {
            this.grassColorModifier = modifier;
            return this;
        }

        public static int hex(String hex) {
            if (hex == null) {
                return 0;
            }
            if ((hex = hex.replace("#", "")).length() != 6) {
                throw new IllegalArgumentException("Invalid hex color: " + hex);
            }
            return Integer.parseInt(hex, 16);
        }

        public Effects clone() {
            try {
                return (Effects)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }

    public static class Generation
    implements Cloneable {
        private List<String> carvers = new ArrayList<String>();
        private List<List<String>> features = new ArrayList<List<String>>();
        public static final Codec<Generation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("carvers", Collections.emptyList()).forGetter(g -> g.carvers == null ? Collections.emptyList() : g.carvers), (App)Codec.STRING.listOf().listOf().optionalFieldOf("features", Collections.emptyList()).forGetter(g -> g.features == null ? Collections.emptyList() : g.features)).apply((Applicative)instance, (carvers, features) -> {
            Generation g = new Generation();
            g.carvers = new ArrayList<String>((Collection<String>)carvers);
            g.features = new ArrayList<List<String>>();
            for (List step : features) {
                g.features.add(new ArrayList(step));
            }
            return g;
        }));

        public Generation addCarver(String id) {
            if (id != null) {
                this.carvers.add(id);
            }
            return this;
        }

        private void ensureStep(int step) {
            while (this.features.size() <= step) {
                this.features.add(new ArrayList());
            }
        }

        public Generation addFeature(int step, String id) {
            if (id == null) {
                return this;
            }
            this.ensureStep(step);
            this.features.get(step).add(id);
            return this;
        }

        public List<String> getCarvers() {
            return Collections.unmodifiableList(this.carvers);
        }

        public List<List<String>> getFeaturesByStep() {
            ArrayList<List<String>> copy = new ArrayList<List<String>>(this.features.size());
            for (List<String> step : this.features) {
                copy.add(Collections.unmodifiableList(step));
            }
            return Collections.unmodifiableList(copy);
        }

        public Generation clone() {
            try {
                Generation clone = (Generation)super.clone();
                clone.carvers = new ArrayList<String>(this.carvers);
                clone.features = new ArrayList<List<String>>();
                for (List<String> step : this.features) {
                    clone.features.add(new ArrayList<String>(step));
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }

    public static abstract class AttributeValue {
        public static final Codec<AttributeValue> CODEC = new Codec<AttributeValue>(){

            public <T> DataResult<T> encode(AttributeValue value, DynamicOps<T> ops, T prefix) {
                if (value instanceof BoolValue) {
                    BoolValue b = (BoolValue)value;
                    return DataResult.success((Object)ops.createBoolean(b.value));
                }
                if (value instanceof NumberValue) {
                    NumberValue n = (NumberValue)value;
                    return DataResult.success((Object)ops.createDouble(n.value));
                }
                if (value instanceof StringValue) {
                    StringValue s = (StringValue)value;
                    return DataResult.success((Object)ops.createString(s.value));
                }
                return DataResult.error(() -> "Unknown AttributeValue subclass: " + String.valueOf(value.getClass()));
            }

            public <T> DataResult<Pair<AttributeValue, T>> decode(DynamicOps<T> ops, T input) {
                Optional boolOpt = ops.getBooleanValue(input).result();
                if (boolOpt.isPresent()) {
                    return DataResult.success((Object)Pair.of((Object)AttributeValue.ofBoolean((Boolean)boolOpt.get()), input));
                }
                Optional numOpt = ops.getNumberValue(input).result();
                if (numOpt.isPresent()) {
                    return DataResult.success((Object)Pair.of((Object)AttributeValue.ofNumber(((Number)numOpt.get()).doubleValue()), input));
                }
                Optional strOpt = ops.getStringValue(input).result();
                if (strOpt.isPresent()) {
                    return DataResult.success((Object)Pair.of((Object)AttributeValue.ofString((String)strOpt.get()), input));
                }
                return DataResult.error(() -> "Unsupported attribute value (not bool/number/string)");
            }
        };

        public static AttributeValue ofBoolean(boolean value) {
            return new BoolValue(value);
        }

        public static AttributeValue ofNumber(double value) {
            return new NumberValue(value);
        }

        public static AttributeValue ofString(String value) {
            return new StringValue(value);
        }

        public static final class BoolValue
        extends AttributeValue {
            public final boolean value;

            public BoolValue(boolean value) {
                this.value = value;
            }
        }

        public static final class NumberValue
        extends AttributeValue {
            public final double value;

            public NumberValue(double value) {
                this.value = value;
            }
        }

        public static final class StringValue
        extends AttributeValue {
            public final String value;

            public StringValue(String value) {
                this.value = value;
            }
        }
    }

    public static class Attributes
    implements Cloneable {
        private final Map<String, AttributeValue> values = new LinkedHashMap<String, AttributeValue>();
        public static final Codec<Attributes> CODEC = Codec.unboundedMap((Codec)Codec.STRING, AttributeValue.CODEC).xmap(Attributes::fromMap, Attributes::toMap);

        private static Attributes fromMap(Map<String, AttributeValue> map) {
            Attributes attrs = new Attributes();
            attrs.values.putAll(map);
            return attrs;
        }

        private Map<String, AttributeValue> toMap() {
            return new LinkedHashMap<String, AttributeValue>(this.values);
        }

        public Attributes putString(String key, String value) {
            if (key != null && value != null) {
                this.values.put(key, AttributeValue.ofString(value));
            }
            return this;
        }

        public Attributes putNumber(String key, double value) {
            if (key != null) {
                this.values.put(key, AttributeValue.ofNumber(value));
            }
            return this;
        }

        public Attributes putBoolean(String key, boolean value) {
            if (key != null) {
                this.values.put(key, AttributeValue.ofBoolean(value));
            }
            return this;
        }

        public Map<String, AttributeValue> getValues() {
            return Collections.unmodifiableMap(this.values);
        }

        public Attributes skyColorAttr(String hexRgb) {
            return this.putString("minecraft:visual/sky_color", hexRgb);
        }

        public Attributes fogColorAttr(String hexRgb) {
            return this.putString("minecraft:visual/fog_color", hexRgb);
        }

        public Attributes waterFogColorAttr(String hexRgb) {
            return this.putString("minecraft:visual/water_fog_color", hexRgb);
        }

        public Attributes waterFogEndDistance(float radius) {
            return this.putNumber("minecraft:visual/water_fog_start_distance", radius);
        }

        public Attributes waterFogStartDistance(float radius) {
            return this.putNumber("minecraft:visual/water_fog_end_distance", radius);
        }

        public Attributes cloudOpacityAttr(float opacity) {
            return this.putNumber("minecraft:visual/cloud_opacity", opacity);
        }

        public Attributes extraFogAttr(boolean enabled) {
            return this.putBoolean("minecraft:visual/extra_fog", enabled);
        }

        public Attributes waterEvaporatesAttr(boolean evaporates) {
            return this.putBoolean("minecraft:gameplay/water_evaporates", evaporates);
        }

        public Attributes clone() {
            try {
                Attributes clone = (Attributes)super.clone();
                clone.values.clear();
                clone.values.putAll(this.values);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }
}

