/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.JsonBytes;
import net.devtech.arrp.json.advancement.JAdvancement;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.equipmentinfo.JEquipmentModel;
import net.devtech.arrp.json.iteminfo.JItemInfo;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.json.timeline.JTimeline;
import net.devtech.arrp.json.worldgen.biome.JBiome;
import net.devtech.arrp.json.worldgen.dimension.JDimension;
import net.devtech.arrp.json.worldgen.dimension.JDimensionType;
import net.devtech.arrp.json.worldgen.feature.JConfiguredFeature;
import net.devtech.arrp.json.worldgen.feature.JPlacedFeature;
import net.devtech.arrp.json.worldgen.noise.JNoiseSettings;
import net.devtech.arrp.json.worldgen.structure.JStructure;
import net.devtech.arrp.json.worldgen.structure.JStructureSet;
import net.devtech.arrp.util.CallableFunction;
import net.devtech.arrp.util.CountingInputStream;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public class RuntimeResourcePackImpl
extends AbstractPackResources
implements RuntimeResourcePack {
    public static final ExecutorService EXECUTOR_SERVICE;
    public static final boolean DUMP;
    public static final boolean DEBUG_PERFORMANCE;
    public static final Gson GSON;
    static final Set<String> KEY_WARNINGS;
    public static final Logger LOGGER;
    private final Identifier id;
    private final Lock waiting = new ReentrantLock();
    private final Map<Identifier, Supplier<byte[]>> data = new ConcurrentHashMap<Identifier, Supplier<byte[]>>();
    private final Map<Identifier, Supplier<byte[]>> assets = new ConcurrentHashMap<Identifier, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    private final Map<Identifier, JLang> langMergable = new ConcurrentHashMap<Identifier, JLang>();

    public RuntimeResourcePackImpl(Identifier id) {
        super(new PackLocationInfo(id.getNamespace() + ";" + id.getPath(), Component.nullToEmpty((String)("Runtime Resource Pack " + String.valueOf(id))), PackSource.DEFAULT, Optional.empty()));
        this.id = id;
    }

    @Override
    public void addRecoloredImage(Identifier identifier, InputStream target, IntUnaryOperator operator) {
        this.addLazyResource(PackType.CLIENT_RESOURCES, RuntimeResourcePackImpl.fix(identifier, "textures", "png"), (i, r) -> {
            try {
                CountingInputStream is = new CountingInputStream(target);
                BufferedImage base = ImageIO.read(is);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
                    }
                }
                UnsafeByteArrayOutputStream baos = new UnsafeByteArrayOutputStream(is.bytes());
                ImageIO.write((RenderedImage)recolored, "png", baos);
                return baos.getBytes();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(Identifier identifier, JLang lang) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "lang", "json"), RuntimeResourcePackImpl.serialize(lang.getLang()));
    }

    @Override
    public void mergeLang(Identifier identifier, JLang lang) {
        this.langMergable.compute(identifier, (identifier1, lang1) -> {
            if (lang1 == null) {
                JLang finalLang = lang1 = new JLang();
                this.addLazyResource(PackType.CLIENT_RESOURCES, identifier, (pack, identifier2) -> pack.addLang(identifier, finalLang));
            }
            lang1.getLang().putAll(lang.getLang());
            return lang1;
        });
    }

    @Override
    public byte[] addLootTable(Identifier identifier, JLootTable table) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_table", "json"), JsonBytes.encodeToPrettyBytes(JLootTable.CODEC, table));
    }

    @Override
    public Future<byte[]> addAsyncResource(PackType type, Identifier path, CallableFunction<Identifier, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.getSys(type).put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyResource(PackType type, Identifier path, BiFunction<RuntimeResourcePack, Identifier, byte[]> func) {
        this.getSys(type).put(path, new Memoized<Identifier>(this, func, path));
    }

    @Override
    public byte[] addResource(PackType type, Identifier path, byte[] data) {
        this.getSys(type).put(path, () -> data);
        return data;
    }

    @Override
    public Future<byte[]> addAsyncRootResource(String path, CallableFunction<String, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.root.put(Arrays.asList(path.split("/")), () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        this.root.put(Arrays.asList(path.split("/")), new Memoized<String>(this, data, path));
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Override
    public byte[] addAsset(Identifier path, byte[] data) {
        return this.addResource(PackType.CLIENT_RESOURCES, path, data);
    }

    @Override
    public byte[] addData(Identifier path, byte[] data) {
        return this.addResource(PackType.SERVER_DATA, path, data);
    }

    @Override
    public byte[] addAdvancement(JAdvancement advancement, Identifier path) {
        return this.addData(RuntimeResourcePackImpl.fix(this.id, "advancement", "json"), JsonBytes.encodeToPrettyBytes(JAdvancement.CODEC, advancement));
    }

    @Override
    public byte[] addModel(JModel model, Identifier path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "models", "json"), RuntimeResourcePackImpl.serialize(model));
    }

    @Override
    public byte[] addItemModelInfo(JItemInfo model, Identifier path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "items", "json"), JsonBytes.encodeToPrettyBytes(JItemInfo.CODEC, model));
    }

    @Override
    public byte[] addEquipmentModel(JEquipmentModel model, Identifier path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "equipment", "json"), JsonBytes.encodeToPrettyBytes(JEquipmentModel.CODEC, model));
    }

    @Override
    public byte[] addBlockState(JState state, Identifier path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "blockstates", "json"), JsonBytes.encodeToPrettyBytes(JState.CODEC, state));
    }

    @Override
    public byte[] addTexture(Identifier id, BufferedImage image) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", ubaos);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible.", e);
        }
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png"), ubaos.getBytes());
    }

    @Override
    public byte[] addAnimation(Identifier id, JAnimation animation) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png.mcmeta"), RuntimeResourcePackImpl.serialize(animation));
    }

    @Override
    public byte[] addTag(Identifier id, JTag tag) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "tags", "json"), JsonBytes.encodeToPrettyBytes(JTag.CODEC, tag));
    }

    @Override
    public byte[] addRecipe(Identifier id, JRecipe recipe) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipe", "json"), JsonBytes.encodeToPrettyBytes(JRecipe.CODEC, recipe));
    }

    @Override
    public byte[] addTimeline(Identifier id, JTimeline timeline) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "timelines", "json"), JsonBytes.encodeToPrettyBytes(JTimeline.CODEC, timeline));
    }

    @Override
    public byte[] addBiome(Identifier id, JBiome biome) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "worldgen/biome", "json"), JsonBytes.encodeToPrettyBytes(JBiome.CODEC, biome));
    }

    @Override
    public byte[] addDimension(Identifier id, JDimension dimension) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "dimension", "json"), JsonBytes.encodeToPrettyBytes(JDimension.CODEC, dimension));
    }

    @Override
    public byte[] addDimensionType(Identifier id, JDimensionType dimensionType) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "dimension_type", "json"), JsonBytes.encodeToPrettyBytes(JDimensionType.CODEC, dimensionType));
    }

    @Override
    public byte[] addConfiguredFeature(Identifier id, JConfiguredFeature configuredFeature) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "worldgen/configured_feature", "json"), JsonBytes.encodeToPrettyBytes(JConfiguredFeature.CODEC, configuredFeature));
    }

    @Override
    public byte[] addPlacedFeature(Identifier id, JPlacedFeature placedFeature) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "worldgen/placed_feature", "json"), JsonBytes.encodeToPrettyBytes(JPlacedFeature.CODEC, placedFeature));
    }

    @Override
    public byte[] addNoiseSettings(Identifier id, JNoiseSettings noiseSettings) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "worldgen/noise_settings", "json"), JsonBytes.encodeToPrettyBytes(JNoiseSettings.CODEC, noiseSettings));
    }

    @Override
    public byte[] addStructure(Identifier id, JStructure structure) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "worldgen/structure", "json"), JsonBytes.encodeToPrettyBytes(JStructure.CODEC, structure));
    }

    @Override
    public byte[] addStructureSet(Identifier id, JStructureSet structureSet) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "worldgen/structure_set", "json"), JsonBytes.encodeToPrettyBytes(JStructureSet.CODEC, structureSet));
    }

    @Override
    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        this.lock();
        return EXECUTOR_SERVICE.submit(() -> {
            action.accept(this);
            this.waiting.unlock();
        });
    }

    @Override
    public void dumpDirect(Path output) {
        LOGGER.info("dumping {}'s assets and data", (Object)this.id);
        try {
            for (Map.Entry<List<String>, Supplier<byte[]>> e : this.root.entrySet()) {
                String string = String.join((CharSequence)"/", (Iterable<? extends CharSequence>)e.getKey());
                Path path = output.resolve(string);
                if (path.toAbsolutePath().startsWith(output.toAbsolutePath())) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.write(path, (byte[])((Supplier)e.getValue()).get(), new OpenOption[0]);
                    continue;
                }
                LOGGER.error("RRP contains out-of-directory path! \"{}\"", (Object)string);
            }
            Path assets = output.resolve("assets");
            Files.createDirectories(assets, new FileAttribute[0]);
            for (Map.Entry entry : this.assets.entrySet()) {
                this.write(assets, (Identifier)entry.getKey(), (byte[])((Supplier)entry.getValue()).get());
            }
            Path data = output.resolve("data");
            Files.createDirectories(data, new FileAttribute[0]);
            for (Map.Entry<Identifier, Supplier<byte[]>> entry : this.data.entrySet()) {
                this.write(data, entry.getKey(), entry.getValue().get());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void load(Path dir) throws IOException {
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
                String path;
                String s = file.toString();
                if (s.startsWith("assets")) {
                    path = s.substring("assets".length() + 1);
                    this.load(path, this.assets, Files.readAllBytes(file));
                    continue;
                }
                if (s.startsWith("data")) {
                    path = s.substring("data".length() + 1);
                    this.load(path, this.data, Files.readAllBytes(file));
                    continue;
                }
                byte[] data = Files.readAllBytes(file);
                this.root.put(Arrays.asList(s.split("/")), () -> data);
            }
        }
    }

    @Override
    public void dump(ZipOutputStream zos) throws IOException {
        Identifier id;
        this.lock();
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
            zos.putNextEntry(new ZipEntry(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey())));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.assets.entrySet()) {
            id = (Identifier)entry.getKey();
            zos.putNextEntry(new ZipEntry("assets/" + id.getNamespace() + "/" + id.getPath()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.data.entrySet()) {
            id = (Identifier)entry.getKey();
            zos.putNextEntry(new ZipEntry("data/" + id.getNamespace() + "/" + id.getPath()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        this.waiting.unlock();
    }

    @Override
    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String path;
            String s = entry.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public IoSupplier<InputStream> getRootResource(String ... segments) {
        this.lock();
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(segments));
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public IoSupplier<InputStream> getResource(PackType type, Identifier id) {
        this.lock();
        Supplier<byte[]> supplier = this.getSys(type).get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        this.lock();
        for (Identifier identifier : this.getSys(type).keySet()) {
            Supplier<byte[]> supplier = this.getSys(type).get(identifier);
            if (supplier == null) {
                this.waiting.unlock();
                continue;
            }
            IoSupplier inputSupplier = () -> new ByteArrayInputStream((byte[])supplier.get());
            if (!identifier.getNamespace().equals(namespace) || !identifier.getPath().startsWith(prefix)) continue;
            consumer.accept((Object)identifier, (Object)inputSupplier);
        }
        this.waiting.unlock();
    }

    public Set<String> getNamespaces(PackType type) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (Identifier identifier : this.getSys(type).keySet()) {
            namespaces.add(identifier.getNamespace());
        }
        this.waiting.unlock();
        return namespaces;
    }

    public void close() {
        LOGGER.info("closing rrp {}", (Object)this.id);
        this.lock();
        if (DUMP) {
            this.dump();
        }
        this.waiting.unlock();
    }

    private static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    private static Identifier fix(Identifier identifier, String prefix, String append) {
        return Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)(prefix + "/" + identifier.getPath() + "." + append));
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<Identifier, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(Identifier.fromNamespaceAndPath((String)namespace, (String)path), () -> data);
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            if (DEBUG_PERFORMANCE) {
                long start = System.currentTimeMillis();
                this.waiting.lock();
                long end = System.currentTimeMillis();
                LOGGER.warn("waited " + (end - start) + "ms for lock in RRP: " + String.valueOf(this.id));
            } else {
                this.waiting.lock();
            }
        }
    }

    private void write(Path dir, Identifier identifier, byte[] data) {
        block9: {
            try {
                String namespace = identifier.getNamespace();
                String path = identifier.getPath();
                Path file = dir.resolve(namespace).resolve(path);
                if (file.toAbsolutePath().startsWith(dir.toAbsolutePath())) {
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                        output.write(data);
                        break block9;
                    }
                }
                LOGGER.error("RRP contains out-of-directory location! \"" + namespace + "/" + path + "\"");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<Identifier, Supplier<byte[]>> getSys(PackType side) {
        return side == PackType.CLIENT_RESOURCES ? this.assets : this.data;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(JTextures.class, (Object)new JTextures.Serializer()).registerTypeAdapter(JAnimation.class, (Object)new JAnimation.Serializer()).create();
        KEY_WARNINGS = Collections.newSetFromMap(new ConcurrentHashMap());
        LOGGER = LogManager.getLogger((String)"RRP");
        Properties properties = new Properties();
        int processors = Math.max(Runtime.getRuntime().availableProcessors() / 2 - 1, 1);
        boolean dump = false;
        boolean performance = false;
        properties.setProperty("threads", String.valueOf(processors));
        properties.setProperty("dump assets", "false");
        properties.setProperty("debug performance", "false");
        File file = new File("config/rrp.properties");
        try (FileReader reader = new FileReader(file);){
            properties.load(reader);
            processors = Integer.parseInt(properties.getProperty("threads"));
            dump = Boolean.parseBoolean(properties.getProperty("dump assets"));
            performance = Boolean.parseBoolean(properties.getProperty("debug performance"));
        }
        catch (Throwable t) {
            LOGGER.warn("Invalid config, creating new one!");
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                properties.store(writer, "number of threads RRP should use for generating resources");
            }
            catch (IOException ex) {
                LOGGER.error("Unable to write to RRP config!");
                ex.printStackTrace();
            }
        }
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(processors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ARRP-Workers-%s").build());
        DUMP = dump;
        DEBUG_PERFORMANCE = performance;
        KEY_WARNINGS.add("filter");
        KEY_WARNINGS.add("language");
    }

    private class Memoized<T>
    implements Supplier<byte[]> {
        private final BiFunction<RuntimeResourcePack, T, byte[]> func;
        private final T path;
        private byte[] data;
        final /* synthetic */ RuntimeResourcePackImpl this$0;

        public Memoized(RuntimeResourcePackImpl runtimeResourcePackImpl, BiFunction<RuntimeResourcePack, T, byte[]> func, T path) {
            RuntimeResourcePackImpl runtimeResourcePackImpl2 = runtimeResourcePackImpl;
            Objects.requireNonNull(runtimeResourcePackImpl2);
            this.this$0 = runtimeResourcePackImpl2;
            this.func = func;
            this.path = path;
        }

        @Override
        public byte[] get() {
            if (this.data == null) {
                this.data = this.func.apply(this.this$0, (RuntimeResourcePack)this.path);
            }
            return this.data;
        }
    }
}

