/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.devtech.arrp.json.advancement.AdvConditions;

public final class JCriterion {
    public String trigger;
    public JsonElement conditions;
    private static final Codec<JsonElement> JSON = new Codec<JsonElement>(){

        public <T> DataResult<T> encode(JsonElement v, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)v).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            return DataResult.success((Object)Pair.of((Object)el, input));
        }
    };
    public static final Codec<JCriterion> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("trigger").forGetter(c -> c.trigger), (App)JSON.optionalFieldOf("conditions").forGetter(c -> Optional.ofNullable(c.conditions))).apply((Applicative)i, (t, cond) -> {
        JCriterion c = new JCriterion();
        c.trigger = t;
        c.conditions = cond.orElse(null);
        return c;
    }));

    public static JCriterion of(String trigger) {
        JCriterion c = new JCriterion();
        c.trigger = trigger;
        return c;
    }

    public JCriterion conditions(JsonElement e) {
        this.conditions = e;
        return this;
    }

    public static JCriterion inventoryChanged(AdvConditions.ItemPredicate ... anyOf) {
        JsonObject cond = AdvConditions.inventoryChanged(anyOf);
        return JCriterion.of("minecraft:inventory_changed").conditions((JsonElement)cond);
    }

    public static JCriterion recipeUnlocked(String recipeId) {
        return JCriterion.of("minecraft:recipe_unlocked").conditions((JsonElement)AdvConditions.recipeUnlocked(recipeId));
    }

    public static JCriterion placedBlock(String blockId, Map<String, String> state) {
        return JCriterion.of("minecraft:placed_block").conditions((JsonElement)AdvConditions.placedOrEnterBlock("block", blockId, state));
    }

    public static JCriterion enterBlock(String blockId, Map<String, String> state) {
        return JCriterion.of("minecraft:enter_block").conditions((JsonElement)AdvConditions.placedOrEnterBlock("block", blockId, state));
    }

    public static JCriterion location(AdvConditions.LocationPredicate loc) {
        return JCriterion.of("minecraft:location").conditions((JsonElement)AdvConditions.location(loc));
    }

    public static JCriterion playerKilledEntity(AdvConditions.EntityPredicate entity, AdvConditions.DamagePredicate dmg) {
        return JCriterion.of("minecraft:player_killed_entity").conditions((JsonElement)AdvConditions.playerKilledEntity(entity, dmg));
    }

    public static JCriterion tick() {
        return JCriterion.of("minecraft:tick");
    }

    public static JCriterion impossible() {
        return JCriterion.of("minecraft:impossible");
    }
}

