/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import java.util.HashMap;
import java.util.Map;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.blockstate.StairsRot;

public final class BlockstateTemplates {
    private BlockstateTemplates() {
    }

    public static void addSlab(JVariant into, Map<String, ?> base, JBlockModel bottom, JBlockModel top, JBlockModel full) {
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "type", "bottom"), bottom);
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "type", "top"), top);
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "type", "double"), full);
    }

    public static void addStairs(JVariant into, Map<String, ?> base, JBlockModel straight, JBlockModel inner, JBlockModel outer) {
        String[] FAC = new String[]{"north", "south", "west", "east"};
        String[] HAL = new String[]{"top", "bottom"};
        String[] SHP = new String[]{"straight", "inner_left", "inner_right", "outer_left", "outer_right"};
        for (String f : FAC) {
            for (String h : HAL) {
                String[] stringArray = SHP;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s;
                    JBlockModel ref = switch (s = stringArray[i]) {
                        case "inner_left", "inner_right" -> inner;
                        case "outer_left", "outer_right" -> outer;
                        default -> straight;
                    };
                    into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", f, "half", h, "shape", s), ref);
                }
            }
        }
    }

    public static void addWall(JMultipart multipart, Map<String, ?> base, JBlockModel post, JBlockModel side, JBlockModel sideTall) {
        multipart.when(base).addModel(post);
        multipart.when(BlockstateTemplates.plus(base, "north", "low")).addModel(side.uvlock().y(0));
        multipart.when(BlockstateTemplates.plus(base, "east", "low")).addModel(side.uvlock().y(90));
        multipart.when(BlockstateTemplates.plus(base, "south", "low")).addModel(side.uvlock().y(180));
        multipart.when(BlockstateTemplates.plus(base, "west", "low")).addModel(side.uvlock().y(270));
        multipart.when(BlockstateTemplates.plus(base, "north", "tall")).addModel(sideTall.uvlock().y(0));
        multipart.when(BlockstateTemplates.plus(base, "east", "tall")).addModel(sideTall.uvlock().y(90));
        multipart.when(BlockstateTemplates.plus(base, "south", "tall")).addModel(sideTall.uvlock().y(180));
        multipart.when(BlockstateTemplates.plus(base, "west", "tall")).addModel(sideTall.uvlock().y(270));
    }

    public static Map<String, Object> plus(Map<String, ?> base, String k, Object v) {
        HashMap<String, Object> out = new HashMap<String, Object>(base.size() + 1);
        out.putAll(base);
        out.put(k, v);
        return out;
    }

    public static Map<String, Object> plus(Map<String, ?> base, String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        HashMap<String, Object> out = new HashMap<String, Object>(base.size() + 3);
        out.putAll(base);
        out.put(k1, v1);
        out.put(k2, v2);
        out.put(k3, v3);
        return out;
    }

    public static void addSingle(JVariant into, Map<String, ?> base, JBlockModel model) {
        into.put(base, model);
    }

    public static void addSingle(JVariant into, Map<String, ?> base, JBlockModel ... models) {
        into.put(base, models);
    }

    public static void addSingleWeighted(JVariant into, Map<String, ?> base, JBlockModel model, int weight) {
        into.putWeighted(base, model, weight);
    }

    public static void cubeAll(JVariant into, Map<String, ?> base, JBlockModel cubeModel) {
        into.put(base, cubeModel);
    }

    public static void cubeAll(JMultipart multipart, Map<String, ?> base, JBlockModel cubeModel) {
        multipart.when(base).addModel(cubeModel);
    }

    public static void addStairsRotated(JVariant into, Map<String, ?> base, JBlockModel straight, JBlockModel inner, JBlockModel outer) {
        String[] FAC = new String[]{"east", "south", "west", "north"};
        String[] HAL = new String[]{"bottom", "top"};
        String[] SHP = new String[]{"straight", "inner_left", "inner_right", "outer_left", "outer_right"};
        for (String f : FAC) {
            int y = StairsRot.yForFacing(f);
            for (String h : HAL) {
                int x = StairsRot.xForHalf(h);
                String[] stringArray = SHP;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s;
                    JBlockModel ref = switch (s = stringArray[i]) {
                        case "inner_left", "inner_right" -> inner;
                        case "outer_left", "outer_right" -> outer;
                        default -> straight;
                    };
                    into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", f, "half", h, "shape", s), ref.y(y).x(x).uvlock());
                }
            }
        }
    }

    public static void addPillarAxis(JVariant into, Map<String, ?> base, JBlockModel upright) {
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "axis", "y"), upright);
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "axis", "x"), upright.x(90));
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "axis", "z"), upright.x(90).y(90));
    }

    public static void addHorizontalFacing(JVariant into, Map<String, ?> base, JBlockModel frontModel, AuthoredFacing authored) {
        int yNorth = authored == AuthoredFacing.NORTH ? 0 : 270;
        int yEast = authored == AuthoredFacing.NORTH ? 90 : 0;
        int ySouth = authored == AuthoredFacing.NORTH ? 180 : 90;
        int yWest = authored == AuthoredFacing.NORTH ? 270 : 180;
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "north"), frontModel.y(yNorth).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "east"), frontModel.y(yEast).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "south"), frontModel.y(ySouth).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "west"), frontModel.y(yWest).uvlock());
    }

    public static void addDirectionalFacing(JVariant into, Map<String, ?> base, JBlockModel model, AuthoredFacing authored) {
        JBlockModel baseModel = authored == AuthoredFacing.EAST ? model.y(270) : model;
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "north"), baseModel.y(0).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "east"), baseModel.y(90).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "south"), baseModel.y(180).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "west"), baseModel.y(270).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "up"), baseModel.x(270).uvlock());
        into.put((Map<String, ?>)BlockstateTemplates.plus(base, "facing", "down"), baseModel.x(90).uvlock());
    }

    public static void addEveryDirection(JVariant into, Map<String, ?> base, JBlockModel model, AuthoredFacing authored) {
        BlockstateTemplates.addDirectionalFacing(into, base, model, authored);
    }

    public static enum AuthoredFacing {
        NORTH,
        EAST;

    }
}

