/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.Identifier;

public class JBlockModel
implements Cloneable {
    private final Identifier model;
    private Integer x;
    private Integer y;
    private Boolean uvlock;
    private Integer weight;
    public static final Codec<JBlockModel> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Identifier.CODEC.fieldOf("model").forGetter(m -> m.model), (App)Codec.INT.optionalFieldOf("x").forGetter(m -> Optional.ofNullable(m.x)), (App)Codec.INT.optionalFieldOf("y").forGetter(m -> Optional.ofNullable(m.y)), (App)Codec.BOOL.optionalFieldOf("uvlock").forGetter(m -> Optional.ofNullable(m.uvlock)), (App)Codec.INT.optionalFieldOf("weight").forGetter(m -> Optional.ofNullable(m.weight))).apply((Applicative)inst, (modelId, x, y, uv, w) -> {
        JBlockModel m = new JBlockModel((Identifier)modelId);
        x.ifPresent(m::x);
        y.ifPresent(m::y);
        uv.ifPresent(u -> {
            if (u.booleanValue()) {
                m.uvlock();
            }
        });
        w.ifPresent(m::weight);
        return m;
    }));

    public JBlockModel(Identifier model) {
        this.model = model;
    }

    public JBlockModel clone() {
        try {
            return (JBlockModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public JBlockModel x(int x) {
        this.x = x;
        return this;
    }

    public JBlockModel y(int y) {
        this.y = y;
        return this;
    }

    public JBlockModel uvlock() {
        this.uvlock = true;
        return this;
    }

    public JBlockModel weight(int weight) {
        this.weight = weight;
        return this;
    }
}

