/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.codec.Codecs;
import net.minecraft.util.StringRepresentable;

public final class JVariant
implements Cloneable {
    private static final Codec<List<JBlockModel>> MODELS = Codecs.oneOrList(JBlockModel.CODEC);
    public static final Codec<JVariant> CODEC = Codec.unboundedMap((Codec)Codec.STRING, MODELS).xmap(JVariant::fromMap, v -> v.models);
    private final Map<String, List<JBlockModel>> models = new HashMap<String, List<JBlockModel>>();

    public static String join(Map<String, ?> props) {
        if (props == null || props.isEmpty()) {
            return "";
        }
        return props.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + JVariant.stringify(e.getValue())).collect(Collectors.joining(","));
    }

    private static String stringify(Object v) {
        if (v == null) {
            return "null";
        }
        if (v instanceof Enum) {
            Enum e = (Enum)v;
            return e.name().toLowerCase(Locale.ROOT);
        }
        return v.toString();
    }

    private static JVariant fromMap(Map<String, List<JBlockModel>> m) {
        JVariant v = new JVariant();
        m.forEach((k, list) -> v.models.put((String)k, new ArrayList(list)));
        return v;
    }

    public JVariant put(String key, JBlockModel model) {
        List models = this.models.getOrDefault(key, new ArrayList());
        models.add(model);
        this.models.put(key, models);
        return this;
    }

    public JVariant put(String property, boolean value, JBlockModel model) {
        return this.put(property + "=" + value, model);
    }

    public JVariant put(String property, int value, JBlockModel model) {
        return this.put(property + "=" + value, model);
    }

    public JVariant put(String property, StringRepresentable value, JBlockModel model) {
        return this.put(property + "=" + value.getSerializedName(), model);
    }

    public JVariant put(String property, String value, JBlockModel model) {
        return this.put(property + "=" + value, model);
    }

    public JVariant put(Map<String, ?> props, JBlockModel model) {
        return this.put(JVariant.join(props), model);
    }

    public JVariant put(String key, JBlockModel ... models) {
        List list = this.models.computeIfAbsent(key, k -> new ArrayList());
        Collections.addAll(list, models);
        return this;
    }

    public JVariant putWeighted(String key, JBlockModel model, int weight) {
        int w = Math.max(1, weight);
        List list = this.models.computeIfAbsent(key, k -> new ArrayList());
        for (int i = 0; i < w; ++i) {
            list.add(model);
        }
        return this;
    }

    public JVariant putWeighted(Map<String, ?> props, JBlockModel model, int weight) {
        return this.putWeighted(JVariant.join(props), model, weight);
    }

    public JVariant put(Map<String, ?> props, JBlockModel ... models) {
        return this.put(JVariant.join(props), models);
    }

    public JVariant clone() {
        try {
            return (JVariant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

