/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.equipmentinfo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.devtech.arrp.json.equipmentinfo.JLayer;
import net.devtech.arrp.json.equipmentinfo.LayerType;
import net.minecraft.resources.Identifier;

public final class JEquipmentModel {
    public static final Codec<JEquipmentModel> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)JLayer.CODEC.listOf()).fieldOf("layers").forGetter(m -> {
        LinkedHashMap out = new LinkedHashMap();
        m.layers.forEach((k, arr) -> {
            ArrayList<JLayer> list = new ArrayList<JLayer>(arr.size());
            for (JsonElement el : arr) {
                list.add((JLayer)JLayer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)el).getOrThrow());
            }
            out.put(k, list);
        });
        return out;
    })).apply((Applicative)i, map -> {
        JEquipmentModel m = new JEquipmentModel();
        map.forEach((k, list) -> {
            JsonArray arr = new JsonArray();
            for (JLayer layer : list) {
                arr.add((JsonElement)JLayer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)layer).getOrThrow());
            }
            m.layers.put((String)k, arr);
        });
        return m;
    }));
    private final Map<String, JsonArray> layers = new LinkedHashMap<String, JsonArray>();

    private Map<String, List<JsonElement>> toCodecMap() {
        LinkedHashMap<String, List<JsonElement>> out = new LinkedHashMap<String, List<JsonElement>>();
        for (Map.Entry<String, JsonArray> e : this.layers.entrySet()) {
            ArrayList<JsonElement> list = new ArrayList<JsonElement>(e.getValue().size());
            for (JsonElement el : e.getValue()) {
                list.add(el);
            }
            out.put(e.getKey(), list);
        }
        return out;
    }

    private static JEquipmentModel fromCodecMap(Map<String, List<JsonElement>> map) {
        JEquipmentModel m = new JEquipmentModel();
        for (Map.Entry<String, List<JsonElement>> e : map.entrySet()) {
            JsonArray arr = new JsonArray();
            for (JsonElement el : e.getValue()) {
                arr.add(el);
            }
            m.layers.put(e.getKey(), arr);
        }
        return m;
    }

    private JEquipmentModel() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonObject layersObj = new JsonObject();
        this.layers.forEach((arg_0, arg_1) -> ((JsonObject)layersObj).add(arg_0, arg_1));
        root.add("layers", (JsonElement)layersObj);
        return root;
    }

    public static final class Builder {
        private final JEquipmentModel model = new JEquipmentModel();

        public Builder addLayer(String layerType, JLayer ... layer) {
            JsonArray arr = this.model.layers.computeIfAbsent(layerType, k -> new JsonArray());
            for (JLayer l : layer) {
                arr.add((JsonElement)l.toJson());
            }
            return this;
        }

        public Builder addLayer(Identifier type, JLayer ... layers) {
            return this.addLayer(type.toString(), layers);
        }

        public Builder addLayer(LayerType type, JLayer ... layer) {
            if (type == LayerType.CUSTOM) {
                throw new IllegalArgumentException("Use addLayerCustom(String,\u2026) for CUSTOM types");
            }
            return this.addLayer(type.asString(), layer);
        }

        public Builder addLayerCustom(String customType, JLayer ... layer) {
            return this.addLayer(customType, layer);
        }

        public Builder addLayerCustom(Identifier customType, JLayer ... layers) {
            return this.addLayer(customType.toString(), layers);
        }

        public JEquipmentModel build() {
            return this.model;
        }
    }
}

