/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.devtech.arrp.json.codec.Codecs;
import net.devtech.arrp.json.iteminfo.model.JModelBasic;
import net.devtech.arrp.json.iteminfo.model.JModelComposite;
import net.devtech.arrp.json.iteminfo.model.JModelCondition;
import net.devtech.arrp.json.iteminfo.model.JModelEmpty;
import net.devtech.arrp.json.iteminfo.model.JModelRangeDispatch;
import net.devtech.arrp.json.iteminfo.model.JModelSelect;
import net.devtech.arrp.json.iteminfo.tint.JTint;

public abstract class JItemModel
implements Cloneable {
    protected String type;
    protected List<JTint> tints;
    protected JItemModel fallback;
    private static final Map<String, Codec<? extends JItemModel>> REGISTRY = new ConcurrentHashMap<String, Codec<? extends JItemModel>>();
    public static final Codec<JItemModel> CODEC = Codecs.tagged("type", JItemModel::getType, REGISTRY::get);
    static final Codec<JItemModel> LAZY_SELF = Codec.lazyInitialized(() -> CODEC);

    protected JItemModel() {
    }

    protected JItemModel(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public List<JTint> getTints() {
        return this.tints;
    }

    public JItemModel getFallback() {
        return this.fallback;
    }

    public JItemModel tints(JTint ... tints) {
        this.tints = Arrays.asList(tints);
        return this;
    }

    public JItemModel tints(List<JTint> tints) {
        this.tints = tints;
        return this;
    }

    public JItemModel tint(JTint tint) {
        if (this.tints == null) {
            this.tints = new ArrayList<JTint>();
        }
        this.tints.add(tint);
        return this;
    }

    public JItemModel fallback(JItemModel fb) {
        this.fallback = fb;
        return this;
    }

    public static JModelBasic model(String model) {
        return new JModelBasic(model);
    }

    public static JModelRangeDispatch rangeDispatch() {
        return new JModelRangeDispatch();
    }

    public static JModelComposite composite() {
        return new JModelComposite();
    }

    public static JModelCondition condition() {
        return new JModelCondition();
    }

    public static JModelSelect select() {
        return new JModelSelect();
    }

    public static JModelEmpty empty() {
        return new JModelEmpty();
    }

    public abstract JItemModel clone();

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        if (this.tints != null && !this.tints.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (JTint tint : this.tints) {
                arr.add((JsonElement)tint.toJson());
            }
            json.add("tints", (JsonElement)arr);
        }
        if (this.fallback != null) {
            json.add("fallback", (JsonElement)this.fallback.toJson());
        }
        return json;
    }

    public static void register(String type, MapCodec<? extends JItemModel> codec) {
        REGISTRY.put(type, (Codec<? extends JItemModel>)codec.codec());
    }

    protected Optional<List<JTint>> codecGetTints() {
        return Optional.ofNullable(this.tints).filter(l -> !l.isEmpty());
    }

    protected Optional<JItemModel> codecGetFallback() {
        return Optional.ofNullable(this.fallback);
    }

    protected static <M extends JItemModel> M applyBase(M m, Optional<List<JTint>> tintsOpt, Optional<JItemModel> fbOpt) {
        tintsOpt.ifPresent(m::tints);
        fbOpt.ifPresent(m::fallback);
        return m;
    }

    protected static <M extends JItemModel> List<RecordCodecBuilder<M, ?>> baseFields() {
        return List.of(JTint.CODEC.listOf().optionalFieldOf("tints").forGetter(JItemModel::codecGetTints), LAZY_SELF.optionalFieldOf("fallback").forGetter(JItemModel::codecGetFallback));
    }
}

