/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.tint.JTint;

public final class JModelComposite
extends JItemModel {
    public static final String TYPE = "minecraft:composite";
    private List<JItemModel> parts = new ArrayList<JItemModel>();
    public static final MapCodec<JModelComposite> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)JTint.CODEC.listOf().optionalFieldOf("tints").forGetter(JItemModel::codecGetTints), (App)LAZY_SELF.optionalFieldOf("fallback").forGetter(JItemModel::codecGetFallback), (App)LAZY_SELF.listOf().fieldOf("parts").forGetter(JModelComposite::getParts)).apply((Applicative)i, (tints, fallback, parts) -> {
        JModelComposite m = new JModelComposite();
        m.parts = parts;
        JItemModel.applyBase(m, tints, fallback);
        return m;
    }));

    public JModelComposite() {
        super(TYPE);
    }

    public JModelComposite model(JItemModel child) {
        this.parts.add(child);
        return this;
    }

    public JModelComposite models(Collection<? extends JItemModel> children) {
        this.parts.addAll(children);
        return this;
    }

    public List<JItemModel> getParts() {
        return this.parts;
    }

    @Override
    public JModelComposite clone() {
        ArrayList<JItemModel> cp = new ArrayList<JItemModel>();
        for (JItemModel p : this.parts) {
            cp.add(p.clone());
        }
        JModelComposite c = new JModelComposite();
        c.parts = cp;
        if (this.tints != null) {
            for (JTint t : this.tints) {
                c.tint(t.clone());
            }
        }
        if (this.fallback != null) {
            c.fallback(this.fallback.clone());
        }
        return c;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)CODEC.xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }
}

