/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.property.JProperty;
import net.devtech.arrp.json.iteminfo.tint.JTint;

public class JModelCondition
extends JItemModel {
    public static final String TYPE = "minecraft:condition";
    public static final Codec<JModelCondition> CODEC = Codec.of((Encoder)new Encoder<JModelCondition>(){

        public <T> DataResult<T> encode(JModelCondition v, DynamicOps<T> ops, T prefix) {
            DataResult propEl;
            if (v.property == null) {
                return DataResult.error(() -> "condition: missing property");
            }
            if (v.onTrue == null) {
                return DataResult.error(() -> "condition: missing 'on_true'");
            }
            RecordBuilder b = ops.mapBuilder();
            if (v.tints != null && !v.tints.isEmpty()) {
                DataResult tintsNode = JTint.CODEC.listOf().encodeStart(ops, (Object)v.tints);
                if (tintsNode.result().isEmpty()) {
                    return tintsNode;
                }
                b.add(ops.createString("tints"), tintsNode.result().get());
            }
            if (v.fallback != null) {
                DataResult fbNode = JItemModel.CODEC.encodeStart(ops, (Object)v.fallback);
                if (fbNode.result().isEmpty()) {
                    return fbNode;
                }
                b.add(ops.createString("fallback"), fbNode.result().get());
            }
            if ((propEl = JProperty.CODEC.encodeStart(ops, (Object)v.property)).result().isEmpty()) {
                return propEl;
            }
            DataResult propMap = ops.getMap(propEl.result().get());
            if (propMap.result().isEmpty()) {
                return DataResult.error(() -> "condition: property didn't encode to object");
            }
            for (Pair e : ((MapLike)propMap.result().get()).entries().toList()) {
                b.add(e.getFirst(), e.getSecond());
            }
            DataResult t = JItemModel.CODEC.encodeStart(ops, (Object)v.onTrue);
            if (t.result().isEmpty()) {
                return t;
            }
            b.add(ops.createString("on_true"), t.result().get());
            if (v.onFalse != null) {
                DataResult f = JItemModel.CODEC.encodeStart(ops, (Object)v.onFalse);
                if (f.result().isEmpty()) {
                    return f;
                }
                b.add(ops.createString("on_false"), f.result().get());
            }
            return b.build(prefix);
        }
    }, (Decoder)new Decoder<JModelCondition>(){

        public <T> DataResult<Pair<JModelCondition, T>> decode(DynamicOps<T> ops, T input) {
            DataResult propRes;
            DataResult mapRes = ops.getMap(input);
            if (mapRes.result().isEmpty()) {
                return DataResult.error(() -> "condition: expected object");
            }
            MapLike map = (MapLike)mapRes.result().get();
            Object tintsNode = map.get("tints");
            List tints = null;
            if (tintsNode != null) {
                DataResult tRes = JTint.CODEC.listOf().decode(ops, tintsNode);
                if (tRes.result().isEmpty()) {
                    return DataResult.error(() -> "condition: invalid tints");
                }
                tints = (List)((Pair)tRes.result().get()).getFirst();
            }
            Object fbNode = map.get("fallback");
            JItemModel fallback = null;
            if (fbNode != null) {
                DataResult fRes = JItemModel.CODEC.decode(ops, fbNode);
                if (fRes.result().isEmpty()) {
                    return DataResult.error(() -> "condition: invalid fallback");
                }
                fallback = (JItemModel)((Pair)fRes.result().get()).getFirst();
            }
            if ((propRes = JProperty.CODEC.decode(ops, input)).result().isEmpty()) {
                return DataResult.error(() -> "condition: invalid/missing property");
            }
            JProperty property = (JProperty)((Pair)propRes.result().get()).getFirst();
            Object onTrueNode = map.get("on_true");
            if (onTrueNode == null) {
                return DataResult.error(() -> "condition: missing 'on_true'");
            }
            DataResult onTrueRes = JItemModel.CODEC.decode(ops, onTrueNode);
            if (onTrueRes.result().isEmpty()) {
                return DataResult.error(() -> "condition: invalid 'on_true'");
            }
            JItemModel onTrue = (JItemModel)((Pair)onTrueRes.result().get()).getFirst();
            Object onFalseNode = map.get("on_false");
            JItemModel onFalse = null;
            if (onFalseNode != null) {
                DataResult onFalseRes = JItemModel.CODEC.decode(ops, onFalseNode);
                if (onFalseRes.result().isEmpty()) {
                    return DataResult.error(() -> "condition: invalid 'on_false'");
                }
                onFalse = (JItemModel)((Pair)onFalseRes.result().get()).getFirst();
            }
            JModelCondition m = new JModelCondition();
            m.type = JModelCondition.TYPE;
            m.property = property;
            m.onTrue = onTrue;
            m.onFalse = onFalse;
            if (tints != null && !tints.isEmpty()) {
                for (JTint t : tints) {
                    m.tint(t);
                }
            }
            if (fallback != null) {
                m.fallback(fallback);
            }
            return DataResult.success((Object)Pair.of((Object)m, input));
        }
    });
    private JProperty property;
    private JItemModel onTrue;
    private JItemModel onFalse;

    public JModelCondition() {
        super(TYPE);
    }

    public JModelCondition property(JProperty p) {
        this.property = p;
        return this;
    }

    public JModelCondition onTrue(JItemModel m) {
        this.onTrue = m;
        return this;
    }

    public JModelCondition onFalse(JItemModel m) {
        this.onFalse = m;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JModelCondition when(JProperty p, JItemModel thenModel) {
        return JModelCondition.builder().property(p).then(thenModel).build();
    }

    public static JModelCondition when(JProperty p, JItemModel thenModel, JItemModel elseModel) {
        return JModelCondition.builder().property(p).then(thenModel).otherwise(elseModel).build();
    }

    @Override
    public JModelCondition clone() {
        JModelCondition out = new JModelCondition();
        out.property = this.property;
        out.onTrue = this.onTrue != null ? this.onTrue.clone() : null;
        JItemModel jItemModel = out.onFalse = this.onFalse != null ? this.onFalse.clone() : null;
        if (this.fallback != null) {
            out.fallback(this.fallback.clone());
        }
        if (this.tints != null) {
            for (JTint t : this.tints) {
                out.tint(t.clone());
            }
        }
        return out;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)MapCodec.assumeMapUnsafe(CODEC).xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }

    public static final class Builder {
        private JProperty property;
        private JItemModel onTrue;
        private JItemModel onFalse;
        private final List<JTint> tints = new ArrayList<JTint>();
        private JItemModel fallback;

        public Builder property(JProperty p) {
            this.property = p;
            return this;
        }

        public Builder then(JItemModel m) {
            this.onTrue = m;
            return this;
        }

        public Builder otherwise(JItemModel m) {
            this.onFalse = m;
            return this;
        }

        public Builder tint(JTint t) {
            if (t != null) {
                this.tints.add(t);
            }
            return this;
        }

        public Builder tints(Collection<? extends JTint> ts) {
            if (ts != null) {
                this.tints.addAll(ts);
            }
            return this;
        }

        public Builder fallback(JItemModel fb) {
            this.fallback = fb;
            return this;
        }

        public JModelCondition build() {
            JModelCondition c = new JModelCondition();
            c.property = Objects.requireNonNull(this.property, "property");
            c.onTrue = Objects.requireNonNull(this.onTrue, "on_true");
            c.onFalse = this.onFalse;
            if (!this.tints.isEmpty()) {
                c.tints(this.tints);
            }
            if (this.fallback != null) {
                c.fallback(this.fallback);
            }
            return c;
        }
    }
}

