/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.model.JRangeEntry;
import net.devtech.arrp.json.iteminfo.property.JProperty;
import net.devtech.arrp.json.iteminfo.tint.JTint;

public class JModelRangeDispatch
extends JItemModel {
    public static final String TYPE = "minecraft:range_dispatch";
    public static final Codec<JModelRangeDispatch> CODEC = Codec.of((Encoder)new Encoder<JModelRangeDispatch>(){

        public <T> DataResult<T> encode(JModelRangeDispatch v, DynamicOps<T> ops, T prefix) {
            DataResult entriesEl;
            DataResult propEl;
            if (v.property == null) {
                return DataResult.error(() -> "range_dispatch: missing property");
            }
            if (v.entries == null || v.entries.isEmpty()) {
                return DataResult.error(() -> "range_dispatch: empty 'entries'");
            }
            RecordBuilder b = ops.mapBuilder();
            if (v.tints != null && !v.tints.isEmpty()) {
                DataResult tintsEl = JTint.CODEC.listOf().encodeStart(ops, (Object)v.tints);
                if (tintsEl.result().isEmpty()) {
                    return tintsEl;
                }
                b.add(ops.createString("tints"), tintsEl.result().get());
            }
            if (v.fallback != null) {
                DataResult fbEl = JItemModel.CODEC.encodeStart(ops, (Object)v.fallback);
                if (fbEl.result().isEmpty()) {
                    return fbEl;
                }
                b.add(ops.createString("fallback"), fbEl.result().get());
            }
            if ((propEl = JProperty.CODEC.encodeStart(ops, (Object)v.property)).result().isEmpty()) {
                return propEl;
            }
            DataResult propMap = ops.getMap(propEl.result().get());
            if (propMap.result().isEmpty()) {
                return DataResult.error(() -> "range_dispatch: property didn't encode to object");
            }
            for (Pair e : ((MapLike)propMap.result().get()).entries().toList()) {
                b.add(e.getFirst(), e.getSecond());
            }
            if (v.scale != 1.0) {
                b.add(ops.createString("scale"), ops.createDouble(v.scale));
            }
            if ((entriesEl = JRangeEntry.CODEC.listOf().encodeStart(ops, v.entries)).result().isEmpty()) {
                return entriesEl;
            }
            b.add(ops.createString("entries"), entriesEl.result().get());
            return b.build(prefix);
        }
    }, (Decoder)new Decoder<JModelRangeDispatch>(){

        public <T> DataResult<Pair<JModelRangeDispatch, T>> decode(DynamicOps<T> ops, T input) {
            Object entriesNode;
            DataResult propRes;
            DataResult mapRes = ops.getMap(input);
            if (mapRes.result().isEmpty()) {
                return DataResult.error(() -> "range_dispatch: expected object");
            }
            MapLike map = (MapLike)mapRes.result().get();
            List tints = null;
            Object tNode = map.get("tints");
            if (tNode != null) {
                DataResult tRes = JTint.CODEC.listOf().decode(ops, tNode);
                if (tRes.result().isEmpty()) {
                    return DataResult.error(() -> "range_dispatch: invalid tints");
                }
                tints = (List)((Pair)tRes.result().get()).getFirst();
            }
            JItemModel fallback = null;
            Object fbNode = map.get("fallback");
            if (fbNode != null) {
                DataResult fbRes = JItemModel.CODEC.decode(ops, fbNode);
                if (fbRes.result().isEmpty()) {
                    return DataResult.error(() -> "range_dispatch: invalid fallback");
                }
                fallback = (JItemModel)((Pair)fbRes.result().get()).getFirst();
            }
            if ((propRes = JProperty.CODEC.decode(ops, input)).result().isEmpty()) {
                return DataResult.error(() -> "range_dispatch: invalid/missing property");
            }
            Double scale = null;
            DataResult scaleNum = ops.getNumberValue(map.get("scale"));
            if (scaleNum.result().isPresent()) {
                scale = ((Number)scaleNum.result().get()).doubleValue();
            }
            if ((entriesNode = map.get("entries")) == null) {
                return DataResult.error(() -> "range_dispatch: missing 'entries'");
            }
            DataResult entriesRes = JRangeEntry.CODEC.listOf().decode(ops, entriesNode);
            if (entriesRes.result().isEmpty()) {
                return DataResult.error(() -> "range_dispatch: invalid 'entries'");
            }
            JModelRangeDispatch m = new JModelRangeDispatch();
            m.type = JModelRangeDispatch.TYPE;
            m.property = (JProperty)((Pair)propRes.result().get()).getFirst();
            m.scale = scale == null ? 1.0 : scale;
            m.entries = (List)((Pair)entriesRes.result().get()).getFirst();
            if (tints != null && !tints.isEmpty()) {
                for (JTint t : tints) {
                    m.tint(t);
                }
            }
            if (fallback != null) {
                m.fallback(fallback);
            }
            return DataResult.success((Object)Pair.of((Object)m, input));
        }
    });
    private JProperty property;
    private double scale = 1.0;
    private List<JRangeEntry> entries = new ArrayList<JRangeEntry>();

    public JModelRangeDispatch() {
        super(TYPE);
    }

    public JModelRangeDispatch(JProperty property, double scale, List<JRangeEntry> entries) {
        this();
        this.property = property;
        this.scale = scale;
        this.entries = entries;
    }

    private JsonArray serializeEntries() {
        JsonArray entriesArray = new JsonArray();
        for (JRangeEntry entry : this.entries) {
            entriesArray.add((JsonElement)entry.toJson());
        }
        return entriesArray;
    }

    public JProperty getProperty() {
        return this.property;
    }

    public JModelRangeDispatch property(JProperty property) {
        this.property = property;
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public JModelRangeDispatch scale(double scale) {
        this.scale = scale;
        return this;
    }

    public List<JRangeEntry> getEntries() {
        return this.entries;
    }

    public JModelRangeDispatch entries(List<JRangeEntry> entries) {
        this.entries = entries;
        return this;
    }

    public JModelRangeDispatch entry(JRangeEntry entry) {
        this.entries.add(entry);
        return this;
    }

    @Override
    public JModelRangeDispatch clone() {
        JModelRangeDispatch cloned = new JModelRangeDispatch();
        cloned.property = this.property;
        cloned.scale = this.scale;
        cloned.fallback = this.fallback != null ? this.fallback.clone() : null;
        for (JRangeEntry entry : this.entries) {
            cloned.entry(entry.clone());
        }
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)MapCodec.assumeMapUnsafe(CODEC).xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }
}

