/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.model.JSelectCase;
import net.devtech.arrp.json.iteminfo.property.JProperty;
import net.devtech.arrp.json.iteminfo.tint.JTint;

public class JModelSelect
extends JItemModel {
    public static final String TYPE = "minecraft:select";
    public static final Codec<JModelSelect> CODEC = Codec.of((Encoder)new Encoder<JModelSelect>(){

        public <T> DataResult<T> encode(JModelSelect v, DynamicOps<T> ops, T prefix) {
            DataResult propRes;
            if (v.property == null) {
                return DataResult.error(() -> "JModelSelect: missing property");
            }
            if (v.cases == null || v.cases.isEmpty()) {
                return DataResult.error(() -> "JModelSelect: empty 'cases'");
            }
            RecordBuilder builder = ops.mapBuilder();
            if (v.tints != null && !v.tints.isEmpty()) {
                DataResult tintsRes = JTint.CODEC.listOf().encode((Object)v.tints, ops, ops.empty());
                if (tintsRes.result().isEmpty()) {
                    return tintsRes;
                }
                builder.add(ops.createString("tints"), tintsRes.result().get());
            }
            if (v.fallback != null) {
                DataResult fbRes = JItemModel.CODEC.encode((Object)v.fallback, ops, ops.empty());
                if (fbRes.result().isEmpty()) {
                    return fbRes;
                }
                builder.add(ops.createString("fallback"), fbRes.result().get());
            }
            if ((propRes = JProperty.CODEC.encode((Object)v.property, ops, ops.empty())).result().isEmpty()) {
                return propRes;
            }
            DataResult mapRes = ops.getMap(propRes.result().get());
            if (mapRes.result().isEmpty()) {
                return DataResult.error(() -> "JModelSelect: property didn't encode to an object");
            }
            for (Pair e : ((MapLike)mapRes.result().get()).entries().toList()) {
                builder.add(e.getFirst(), e.getSecond());
            }
            DataResult casesRes = JSelectCase.CODEC.listOf().encode(v.cases, ops, ops.empty());
            if (casesRes.result().isEmpty()) {
                return casesRes;
            }
            builder.add(ops.createString("cases"), casesRes.result().get());
            return builder.build(prefix);
        }
    }, (Decoder)new Decoder<JModelSelect>(){

        public <T> DataResult<Pair<JModelSelect, T>> decode(DynamicOps<T> ops, T input) {
            DataResult propRes;
            DataResult mapRes = ops.getMap(input);
            if (mapRes.result().isEmpty()) {
                return DataResult.error(() -> "JModelSelect: expected object");
            }
            MapLike map = (MapLike)mapRes.result().get();
            List tints = null;
            Object tNode = map.get("tints");
            if (tNode != null) {
                DataResult tRes = JTint.CODEC.listOf().decode(ops, tNode);
                if (tRes.result().isEmpty()) {
                    return DataResult.error(() -> "JModelSelect: invalid tints");
                }
                tints = (List)((Pair)tRes.result().get()).getFirst();
            }
            JItemModel fallback = null;
            Object fbNode = map.get("fallback");
            if (fbNode != null) {
                DataResult fbRes = JItemModel.CODEC.decode(ops, fbNode);
                if (fbRes.result().isEmpty()) {
                    return DataResult.error(() -> "JModelSelect: invalid fallback");
                }
                fallback = (JItemModel)((Pair)fbRes.result().get()).getFirst();
            }
            if ((propRes = JProperty.CODEC.decode(ops, input)).result().isEmpty()) {
                return DataResult.error(() -> "JModelSelect: invalid/missing inlined property");
            }
            Object casesNode = map.get("cases");
            if (casesNode == null) {
                return DataResult.error(() -> "JModelSelect: missing 'cases'");
            }
            DataResult casesRes = JSelectCase.CODEC.listOf().decode(ops, casesNode);
            if (casesRes.result().isEmpty()) {
                return DataResult.error(() -> "JModelSelect: invalid 'cases'");
            }
            JModelSelect m = new JModelSelect();
            m.type = JModelSelect.TYPE;
            m.property = (JProperty)((Pair)propRes.result().get()).getFirst();
            m.cases = (List)((Pair)casesRes.result().get()).getFirst();
            if (tints != null && !tints.isEmpty()) {
                for (JTint t : tints) {
                    m.tint(t);
                }
            }
            if (fallback != null) {
                m.fallback(fallback);
            }
            return DataResult.success((Object)Pair.of((Object)m, input));
        }
    });
    private JProperty property;
    private List<JSelectCase> cases = new ArrayList<JSelectCase>();

    public JModelSelect() {
        super(TYPE);
    }

    public JProperty getProperty() {
        return this.property;
    }

    public JModelSelect property(JProperty property) {
        this.property = property;
        return this;
    }

    public List<JSelectCase> getCases() {
        return this.cases;
    }

    public JModelSelect cases(List<JSelectCase> cases) {
        this.cases = cases;
        return this;
    }

    public JModelSelect addCase(JSelectCase selectCase) {
        this.cases.add(selectCase);
        return this;
    }

    @Override
    public JModelSelect clone() {
        JModelSelect cloned = new JModelSelect();
        cloned.property = this.property;
        for (JSelectCase selectCase : this.cases) {
            cloned.addCase(selectCase != null ? selectCase.clone() : null);
        }
        cloned.fallback = this.fallback != null ? this.fallback.clone() : null;
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)MapCodec.assumeMapUnsafe(CODEC).xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }
}

