/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.model.special.JModelSpecial;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.SkullBlock;

public class JModelHead
extends JModelSpecial {
    public static final String TYPE = "minecraft:head";
    public static final MapCodec<JModelHead> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SkullBlock.Types.CODEC.fieldOf("kind").forGetter(m -> m.kind), (App)Codec.FLOAT.optionalFieldOf("animation", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.animation)), (App)Identifier.CODEC.optionalFieldOf("texture").forGetter(m -> m.texture)).apply((Applicative)i, JModelHead::new));
    private SkullBlock.Type kind = SkullBlock.Types.PLAYER;
    private float animation = 0.0f;
    private Optional<Identifier> texture = Optional.empty();

    public JModelHead() {
        super(TYPE);
    }

    public JModelHead(SkullBlock.Type kind, float animation, Optional<Identifier> texture) {
        super(TYPE);
        this.kind = kind;
        this.animation = animation;
        this.texture = texture != null ? texture : Optional.empty();
    }

    private static SkullBlock.Type parseKind(String s) {
        String n = s.toLowerCase(Locale.ROOT);
        for (SkullBlock.Types t : SkullBlock.Types.values()) {
            if (!t.getSerializedName().equals(n)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unknown head kind: " + s);
    }

    public SkullBlock.Type getKind() {
        return this.kind;
    }

    public JModelHead kind(SkullBlock.Type kind) {
        this.kind = kind;
        return this;
    }

    public JModelHead kind(String kind) {
        this.kind = JModelHead.parseKind(kind);
        return this;
    }

    public float getAnimation() {
        return this.animation;
    }

    public JModelHead animation(float animation) {
        this.animation = animation;
        return this;
    }

    public Optional<Identifier> getTexture() {
        return this.texture;
    }

    public JModelHead texture(Optional<Identifier> texture) {
        this.texture = texture;
        return this;
    }

    public JModelHead texture(Identifier texture) {
        this.texture = Optional.ofNullable(texture);
        return this;
    }

    @Override
    public JModelHead clone() {
        JModelHead cloned = new JModelHead(this.kind, this.animation, this.texture);
        cloned.base(this.getBase());
        return cloned;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)CODEC.xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }
}

